#if defined(SWIGPYTHON)
%typemap(in) port_type
{
  $1 = PyInt_AsLong($input);
}
%apply port_type { time_type };
%typemap(in, numinputs=0) filenames_rds_results_type& ( filenames_rds_results_type temp ) {
  $1 = &temp;
}

%typemap(argout) filenames_rds_results_type&
{
  //---------------------------------------------------------------------
  // Create a tuple of the file names.
  //---------------------------------------------------------------------
  PyObject*	t = PyTuple_New( ($1)->size( ) );
  int		offset = 0;

  for ( filenames_rds_results_type::const_iterator
	  cur = ($1)->begin( ),
	  last = ($1)->end( );
	cur != last;
	++cur, ++offset )
  {
    PyObject*	s = PyString_FromString( cur->c_str( ) );
    PyTuple_SetItem( t, offset, s );
  }
  //---------------------------------------------------------------------
  // Return the results to the caller.
  //---------------------------------------------------------------------
  if ( (!$result) || ($result == Py_None) )
  {
    $result = t;
  }
  else
  {
    $result = PySequence_Concat( $result, t );
  }
  //---------------------------------------------------------------------
  // Cleanup
  //---------------------------------------------------------------------
  // Py_DECREF( t );
}
#endif /* defined(SWIGPYTHON) */
