#ifndef DISKCACHE_API__SCAN_MOUNT_POINTS_DAEMON_HH
#define DISKCACHE_API__SCAN_MOUNT_POINTS_DAEMON_HH

#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/Task.hh"
#include "ldastoolsal/types.hh"

namespace diskCache
{
  //====================================================================================
  /// \brief Continuous scanning of the mount point lists
  //====================================================================================
  class ScanMountPointsDaemon
    : public LDASTools::AL::Task
  {
  public:
    typedef INT_4U interval_type;

    ScanMountPointsDaemon( std::ostream* Stream );

    ~ScanMountPointsDaemon( );

    static interval_type Interval( );

    static void Interval( interval_type Value );

    virtual void operator()( );

  private:
    //-----------------------------------------------------------
    //-----------------------------------------------------------
    bool			active;

    //-----------------------------------------------------------
    /// \brief Syncronize variable access
    //-----------------------------------------------------------
    static LDASTools::AL::MutexLock::baton_type m_variable_baton;

    //-----------------------------------------------------------
    /// \brief Delay between scans
    //-----------------------------------------------------------
    static interval_type	m_interval;

    bool is_active( ) const;
  };

  inline ScanMountPointsDaemon::interval_type ScanMountPointsDaemon::
  Interval( )
  {
    LDASTools::AL::MutexLock  l( m_variable_baton,
				 __FILE__, __LINE__ );

    return m_interval;
  }

  inline void ScanMountPointsDaemon::
  Interval( interval_type Value )
  {
    LDASTools::AL::MutexLock  l( m_variable_baton,
				 __FILE__, __LINE__ );

    m_interval = Value;
  }

  inline bool ScanMountPointsDaemon::
  is_active( ) const
  {
    LDASTools::AL::MutexLock  l( m_variable_baton,
				 __FILE__, __LINE__ );

    return active;
  }
}
#endif /* DISKCACHE_API__SCAN_MOUNT_POINTS_DAEMON_HH */
