#include <ldas_tools_config.h>

#include <set>

#include "ldastoolsal/MemChecker.hh"
#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/Thread.hh"

#include "Cache/HotDirectory.hh"
#include "diskcachecmd.hh"
#include "MountPointScanner.hh"
#include "ScanMountPointsDaemon.hh"

using LDASTools::AL::MemChecker;
using LDASTools::AL::MutexLock;
using LDASTools::AL::Thread;

namespace diskCache
{
  MutexLock::baton_type ScanMountPointsDaemon::m_variable_baton;

  //-----------------------------------------------------------------------------
  /// This variable specifies the number of milliseconds to delay between
  /// successive scans of the list of mount points.
  ///
  /// The default value is 500 ( 0.5 sec. ).
  //-----------------------------------------------------------------------------
  ScanMountPointsDaemon::interval_type	ScanMountPointsDaemon::m_interval = 500;

  ScanMountPointsDaemon::
  ScanMountPointsDaemon( std::ostream* Stream )
    : active( true )
  {
    delete_on_completion( true );
  }

  ScanMountPointsDaemon::
  ~ScanMountPointsDaemon( )
  {
  }

  void ScanMountPointsDaemon::
  operator()( )
  {
    //---------------------------------------------------------------------------------
    // Scan as long as the application is running.
    //---------------------------------------------------------------------------------
    while( ( is_active( ) )
	   && ( MemChecker::IsExiting( ) == false ) )
    {
      //------------------------------------------------------------------------------
      // Scan through the list of mount points.
      //------------------------------------------------------------------------------
      if ( MountPointScanner::SyncRequest::PendingRequests( ) == 0 )
      {
	MountPointScanner::ScanResults	results;
	ScanMountPointList( results );

	/// \todo
	///     Need to format the results of scanning and then dump out either
	///     to the requested stream or use the logging mechanism.
#if WORKING
	if ( Stream )
	{
	}
	else
	{
	}
#endif /* WORKING */
      }
      //-----------------------------------------------------------------
      /// Suspend scanning for a period of time
      //-----------------------------------------------------------------
      struct timespec wakeup;
      const interval_type	i( Interval( ) );
      wakeup.tv_sec = i / 1000;
      wakeup.tv_nsec = ( i % 1000 ) * 1000000;
      //-----------------------------------------------------------------
      // Modify the cancellation signal to be a true signal to allow
      // interuptability
      //-----------------------------------------------------------------
      int old_aux = 0;
      const Thread::cancel_type
	old_type( Thread::Self::CancellationType( old_aux ) );
      Thread::Self::CancellationType( Thread::CANCEL_BY_SIGNAL, SIGTERM );
      nanosleep( &wakeup, NULL );
      Thread::Self::CancellationType( old_type, old_aux );
    }
    //---------------------------------------------------------------------------------
    //---------------------------------------------------------------------------------
    Cache::HotDirectory::StopDaemon( );
  }
}
