#include "ldastoolsal/MemChecker.hh"
#include "Cache/HotDirectory.hh"

#include "Daemons.hh"
#include "DumpCacheDaemon.hh"
#include "ScanMountPointsDaemon.hh"

using LDASTools::AL::MemChecker;

SINGLETON_INSTANCE_DEFINITION( LDASTools::AL::SingletonHolder< diskCache::Daemon::DumpCache > )
SINGLETON_INSTANCE_DEFINITION( LDASTools::AL::SingletonHolder< diskCache::Daemon::ScanMountPoints > )

namespace
{
  void
  on_exit_dump_cache( )
  {
    diskCache::Daemon::DumpCache::Terminate( );
  }

  void
  on_exit_scan_mount_points( )
  {
    diskCache::Daemon::ScanMountPoints::Terminate( );
  }
}

namespace diskCache
{
  namespace Daemon
  {
    //===================================================================
    //===================================================================
    DumpCache::
    DumpCache( )
    {
      MemChecker::Append( on_exit_dump_cache,
			  "diskCache::Daemon::DumpCache",
			  110,
			  true );
    }

    DumpCache::
    ~DumpCache( )
    {
    }

    void DumpCache::
    Launch( )
    {
      Instance().Start( );
    }

    DumpCache::task_type* DumpCache::
    Task( )
    {
      return new DumpCacheDaemon( );
    }

    void DumpCache::
    Terminate( )
    {
      Instance().Stop( );
    }

    //===================================================================
    //===================================================================
    ScanMountPoints::
    ScanMountPoints( )
    {
      MemChecker::Append( on_exit_scan_mount_points,
			  "diskCache::Daemon::DumpCache",
			  120,
			  true );
    }

    ScanMountPoints::
    ~ScanMountPoints( )
    {
    }

    void ScanMountPoints::
    Launch( )
    {
      Instance().Start( );
    }

    ScanMountPoints::task_type* ScanMountPoints::
    Task( )
    {
      return new ScanMountPointsDaemon( (std::ostream*)NULL );
    }

    void ScanMountPoints::
    Terminate( )
    {
      Instance().Stop( );
      diskCache::Cache::HotDirectory::StopDaemon( );
    }
  }
}
