#ifndef UNEXPECTED_EXCEPTION_HH
#define UNEXPECTED_EXCEPTION_HH

#include <string>
#include <stdexcept>

namespace LDASTools
{
  namespace Error
  {

    /// \brief  A class for capturing information about unexpected exceptions
    ///
    /// This class is intended to be thrown whenever a bad exception
    /// specification is encountered. This will happen if a function
    /// throws an exception that isn't listed in its exception
    /// specification
    ///
    class unexpected_exception : public std::bad_exception {
    public:
      /// \brief  Constructor
      ///
      /// \param what
      ///	The name of the exception that was bad eg. runtime_error
      ///
      /// \param msg
      ///     The what() of the original exception
      unexpected_exception(const std::string& what,
			   const std::string& msg)
	: m_what(what), m_msg(msg) { }

      /// \brief  Destructor
      ///
      ~unexpected_exception() throw() {}

      /// \brief  The name of the bad exception
      ///
      /// Returns the name of the exception thrown by the function
      /// which was not listed in the functions exception specification
      ///
      ///!ret: The name of the bad exception.
      virtual
      const char* what() const throw() { return m_what.c_str(); }

      /// \brief  The what() of the bad exception
      ///
      ///!ret:  The what() of the bad exception
      const char* msg()  const { return m_msg.c_str(); }

    private:
      std::string m_what;
      std::string m_msg;
    };
  } // namespace - Error

} // namespace - LDASTools

#endif // UNEXPECTED_EXCEPTION_HH
