/* -*- c-basic-offset: 2; -*- */
#if HAVE_CONFIG_H
#include <ldas_tools_config.h>
#endif /* HAVE_CONFIG_H */

extern "C" {
#include <assert.h>
}

// Needed for bad_cast exception

#include <cstdlib>
#include <typeinfo>

// Needed for bad_alloc exception
#include <new>

#include <iostream>

#include "LDASUnexpected.hh"
#include "unexpected_exception.hh"

namespace LDASTools
{
  namespace Error
  {

    LDASUnexpected::LDASUnexpected()
      : m_old(std::set_unexpected(LDASUnexpected::unexpected))
    {
    }

    LDASUnexpected::~LDASUnexpected()
    {
      std::set_unexpected(m_old);
    }

    void
    LDASUnexpected::makeAbort( bool Abort )
    {
      m_abort = Abort;
    }

    void
    LDASUnexpected::makeQuiet()
    {
      m_logging = false;
    }

    void
    LDASUnexpected::makeVerbose()
    {
      m_logging = true;
    }

    void LDASUnexpected::unexpected()
    {
      using namespace std;

      string what("");
      string msg("");

#if defined( HAVE_RETHROW_WORKING_IN_BAD_EXCEPTION )
      // This macro is used as a shortcut for catching exceptions
#define CATCH(exc)				\
      catch(exc& e)                             \
      {                                         \
	what = #exc;                            \
	msg = e.what();                         \
      }

      // Rethrow and catch, being sure to traverse the exception
      // class heirarchy from the bottom up
      try {
	throw;
      }
      // Everything derived from logic_error
      CATCH(length_error)
	CATCH(domain_error)
	CATCH(out_of_range)
	CATCH(invalid_argument)
	// Everything derived from runtime_error
	CATCH(underflow_error)
	CATCH(overflow_error)
	CATCH(range_error)
	// Everything derived from bad_exception
	CATCH(unexpected_exception)
	// Everything derived from exception
	CATCH(logic_error)
	CATCH(bad_alloc)
	CATCH(bad_exception)
	CATCH(bad_typeid)
	CATCH(bad_cast)
	CATCH(runtime_error)
	// exception
	CATCH(exception)
	// Everything else
	catch(...)
	{
	  what = "unknown exception";
	  msg = "LDASUnexpected::unexpected: An exception not "
	    "derived from std::exception was encountered";
	}

#undef CATCH
#else   /* HAVE_RETHROW_WORKING_IN_BAD_EXCEPTION */
      what = "unknown exception";
      msg = "LDASUnexpected::unexpected: Compiler "
	"does not support rethrowing of exceptions in unexpected "
	"exception handler.";

#endif  /* HAVE_RETHROW_WORKING_IN_BAD_EXCEPTION */

      if  (m_logging)
      {
	const string log_msg("LDASUnexpected::unexpected: Caught "
			     "unexpected exception      \""
			     //  what + "\" with what() = \"" + msg + "\". "
			     "This is a bug. Please log an LDAS "
			     "problem report including this message.");

	// Since this is a BUG and the AddLogEntry function is
	// totally broken at the moment I'm taking the liberty of
	// writing to stderr. We must have some way to track unexpected
	// exceptions or else we can't fix them
	cerr << log_msg << endl;
      }

      if ( m_abort )
      {
	assert( false );
      }
#if HAVE_NO_RETURN_FROM_UNEXPECTED_HANDLER
      // This is done to prevent segfault and other bad things. This
      // is only done when the compiler is broken.
      exit( 1 );
#else   /* HAVE_NO_RETURN_FROM_UNEXPECTED_HANDLER */
      throw unexpected_exception(what, msg);
#endif  /* HAVE_NO_RETURN_FROM_UNEXPECTED_HANDLER */
    }

    bool LDASUnexpected::m_logging = true;

    bool LDASUnexpected::m_abort = true;

    // The single instance of LDASUnexpected
    const LDASUnexpected LDASUnexpected::TheLDASUnexpected;
  } // namespace - Error

} // namespace - LDASTools
