#ifdef HAVE_CONFIG_H
#include <ldas_tools_config.h>
#endif /* HAVE_CONFIG_H */

#include <sys/types.h>

#include <string.h>
#include <errno.h>

#include "swigexception.hh"

#ifdef WITHOUT_TCL
#undef HAVE_TCL
#endif

//-----------------------------------------------------------------------------
//
//: Constructor
//
// Convert an LdasException.
//
//!param: const LdasException& e
//
#if CORE_API
SwigException::SwigException( const LdasException& e )
        : mResult(), mInfo()
{
    if ( e.getSize() == 0 )
    {
        mResult = "unkown_error";
    }
    else
    {
        size_t index = e.getSize() - 1;
        
        mResult = e[ index ].getMessage();
        if ( e[ index ].getInfo().size() > 0 )
        {
            mResult += std::string( ": " ) + e[ index ].getInfo();
        }

        std::ostringstream ss;
        ss << " [" << e[ index ].getFile() << ":" << e[ index ].getLine()
           << "]";

        while( index != 0 )
        {
            --index;
            ss << "\n" << e[ index ].getMessage();
            if ( e[ index ].getInfo().size() > 0 )
            {
                ss << ": ";
            }
            ss << e[ index ].getInfo() << " [" << e[ index ].getFile()
               << ":" << e[ index ].getLine() << "]";
        }

        mInfo = ss.str();
    }
}
#endif /* CORE_API */

#if ! CORE_API
#if HAVE_TCL
void SwigException::setTcl( Tcl_Interp* interp, Tcl_Obj* tcl_result )
{
    Tcl_SetStringObj( tcl_result, (char*)mResult.c_str(), mResult.length() );
    Tcl_AddObjErrorInfo( interp, (char*)mInfo.c_str(), mInfo.length() );
    Tcl_SetErrorCode( interp, "1", NULL );
}
#endif /* HAVE_TCL */
#endif /* ! CORE_API */

#if CORE_API
std::string SwigException::location( const char* file, int line )
{
    char buffer[10];
    sprintf( buffer, "%u", line );
    return ( std::string(" [") + file + ":" + buffer + "]" );
}
#endif /* CORE_API */

#if CORE_API
std::string SwigException::os_error( void )
{
  if (errno != 0)
  {
    char	buffer[16];
    sprintf(buffer, "%u", errno);
    return ( std::string(" {os err:") + buffer + ":" + strerror(errno) + "} ");
  }
  return "";
}
#endif /* CORE_API */
