/* -*- mode: c++ ; c-basic-offset: 4; -*- */

#ifndef GenericApiOutputFileHH
#define GenericApiOutputFileHH


#include "ldastoolsal/autoarray.hh"
#include "ldastoolsal/fstream.hh"
#include "file.hh"


//-----------------------------------------------------------------------------
//
//: Output File
//
// This class represents a file which is open for output.
//
// <p>The class is
// constructed by passing a filename and an open mode.  The constructor
// creates an underlying ofstream which represents the file.  This ofstream
// is available through an accessor.  The stream is closed when the destructor
// is called.
//
class OutputFile : public File
{
public:
  typedef LDASTools::AL::ofstream	ofstream;
    
  /* Constructor/Destructor */
  OutputFile( const char* filename, std::ios::openmode m );
  OutputFile( const char* filename, std::ios::openmode m,
	      bool use_memory_mapped_io,
	      unsigned int buffer_size,
	      char* buffer = (char*) NULL );
  virtual ~OutputFile();

  /* Accessors */
  ofstream& getofstream();
  virtual bool is_open();
    
private:
    /* Data Members */
    ofstream mStream;
    // Buffer for stream when a size has been specified
    LDASTools::AL::AutoArray<char>	m_buffer;

    // validate the file just opened
    void validate( const char* filename, std::ios::openmode m );
};


//-----------------------------------------------------------------------------
//
//: Get the underlying stream
//
//!return: ofstream&
//
inline OutputFile::ofstream& OutputFile::
getofstream()
{
    return mStream;
}


#endif // GenericApiOutputFileHH
