#include "genericAPI/Logging.hh"

#include "createRDS.hh"
#include "Frame.hh"
#include "rdsframe.hh"
#include "rdsreduce.hh"
#include "rdsresample.hh"
#include "RDSStreamFile.hh"
#include "RDSStreamFileReduce.hh"
#include "RDSStreamFileResample.hh"
#include "RDSStreamMemory.hh"

using GenericAPI::queueLogEntry;
using GenericAPI::IsLogging;
using GenericAPI::LogEntryGroup_type;

namespace
{
}

namespace FrameAPI
{
  Frame
  createRDSFrame( const frame_file_container_type& FrameFiles,
		  start_type Start,
		  end_type End,
		  const channel_container_type& Channels )
  {
    RDS::Options
      opts( Start,		// Start Time
	    End,		// End Time
	    "__none__",		// Output Type
	    "",			// Compression - raw
	    0,			// Compression - level
	    false,		// Verify Checksum
	    false,		// Verify Frame Checksum
	    false,		// Verify Time Range
	    false,		// Verify Data Valid
	    1,			// FramesPerFile
	    End - Start,	// SecondsPerFrame
	    true,		// AllowShortFrames
	    false,		// GenerateFrameChecksum
	    true,		// FillMissingDataValidArray
	    false );		// VerifyFilenameMetadata

    RDSStreamMemory*
      stream( new RDSStreamMemory( ) );

    RDSFrame::stream_type	output;
    Frame			retval;

    output.reset( stream );
    ReduceRawFrame
      request( FrameFiles,	// Filename list
	       Channels.names,	// Channel list
	       opts );
    request.ProcessRequest( output );
    if ( output )
    {
      retval = stream->Results( )[ 0 ];
    }

    return retval;
  }

  void
  createRDSSet( const frame_file_container_type& FrameFiles,
		const channel_container_type& Channels,
		const FrameAPI::RDS::FileOptions& Opts )
  {
    static const char* caller = "FrameAPI::createRDSSet";

    bool	need_to_resample = false;

    for ( channel_container_type::resampling_type::const_iterator
	    cur = Channels.resampling.begin( ),
	    last = Channels.resampling.end( );
	  cur != last;
	  ++cur )
    {
      if ( *cur != 1 )
      {
	need_to_resample = true;
	break;
      }
    }
    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    try
    {
      if ( need_to_resample )
      {
	if ( IsLogging( LogEntryGroup_type::MT_DEBUG,
			20 ) )
	{
	  std::ostringstream	msg;

	  queueLogEntry( "Resampling",
			 LogEntryGroup_type::MT_DEBUG,
			 20,
			 caller,
			 "CREATE_RDS" );
	}
	//---------------------------------------------------------------
	// Resample
	//---------------------------------------------------------------
	RDSStreamFileResample*
	  fstream( new RDSStreamFileResample( Opts.DirectoryOutputFrames( ),
					      Opts.OutputType( ).c_str( ), // OutputType
					      Opts.DirectoryOutputMD5Sum( ) ) );
	RDSFrame::stream_type	stream( fstream );

	ResampleRawFrame::resample_container_type
	  resampling( ResampleRawFrame::Resample( Channels.names,
						  Channels.resampling ) );
	ResampleRawFrame
	  request( FrameFiles,		// Filename list
		   Channels.names,	// Channel list
		   resampling,		// Resampling
		   Opts );
	request.ProcessRequest( stream );
      }
      else
      {
	RDSStreamFileReduce*
	  fstream( new RDSStreamFileReduce( Opts.DirectoryOutputFrames( ),
					    Opts.OutputType( ).c_str( ), // OutputType
					    Opts.DirectoryOutputMD5Sum( ) ) );
	RDSFrame::stream_type	stream( fstream );

	if ( IsLogging( LogEntryGroup_type::MT_DEBUG,
			20 ) )
	{
	  queueLogEntry( "Reducing",
			 LogEntryGroup_type::MT_DEBUG,
			 20,
			 caller,
			 "CREATE_RDS" );
	}
	//---------------------------------------------------------------
	// Reduce
	//---------------------------------------------------------------
	ReduceRawFrame
	  request( FrameFiles,		// Filename list
		   Channels.names,	// Channel list
		   Opts );
	if ( IsLogging( LogEntryGroup_type::MT_DEBUG,
			20 ) )
	{
	  queueLogEntry( "Reducing: Created instance",
			 LogEntryGroup_type::MT_DEBUG,
			 20,
			 caller,
			 "CREATE_RDS" );
	}
	request.ProcessRequest( stream );
	if ( IsLogging( LogEntryGroup_type::MT_DEBUG,
			20 ) )
	{
	  queueLogEntry( "Reducing: Processed Request",
			 LogEntryGroup_type::MT_DEBUG,
			 20,
			 caller,
			 "CREATE_RDS" );
	}
      }
    } 
    catch( const std::exception& E )
    {
      if ( IsLogging( LogEntryGroup_type::MT_DEBUG,
		      0 ) )
      {
	std::ostringstream	msg;

	msg << "Caught excpetion: " << E.what( )
	  ;
	queueLogEntry( msg.str( ),
		       LogEntryGroup_type::MT_DEBUG,
		       0,
		       caller,
		       "CREATE_RDS" );
      }
      throw;
    }
  }
}
