#if HAVE_CONFIG_H
#include <ldas_tools_config.h>
#endif /* HAVE_CONFIG_H */

// #include<malloc.h>

#include <iostream>
#include <fstream>
#include<vector>

#include "ldastoolsal/gpstime.hh"
#include "ldastoolsal/unittest.h"

#include "framecpp/FrameCPP.hh"

#include "framecpp/FrameH.hh"
#include "framecpp/FrHistory.hh"
#include "framecpp/FrRawData.hh"
#include "framecpp/FrAdcData.hh"
#include "framecpp/FrDetector.hh"
#include "framecpp/FrStatData.hh"
#include "framecpp/Dimension.hh"

#include "test.hh"
#include "FrSample.hh"

using namespace FrameCPP::Version;
using namespace std;

// The name of the program executable
char* programname = 0;

void error_watch (const string& msg)
{
  cerr << msg << endl;
}

void
usage( char* f )
{
  if ( ! strncasecmp( f, "-h", 2 ) 
       || ! strncasecmp( f, "--h", 3 ) )
    {
      exit(0);
    }
}

LDASTools::AL::UnitTest	Test;

int
main(int argc, char* argv[])
  try
{
  Test.Init( argc, argv );
  /* Determine program name (strip filesystem path) */
  for (programname = argv [0] + strlen (argv [0]) - 1;
       programname != argv [0] && *programname != '/';
       programname--)
    ;

  if (*programname == '/') 
    programname++;

  //  usage help
  if (argc > 1)
    usage(argv[1]);

  //---------------------------------------------------------------------
  // FrVect
  //---------------------------------------------------------------------
  {
    CHAR data[ 4 ] = { 'a', 'a', 'a', 'a' };
    Dimension datadims[ 1 ] = {
      Dimension( 2, 2.00, "TesT", 2.00 )
    };
    FrVect s( "TesT", 1, datadims, data, "TesT" );
    FrVect d( s );

    Test.Check( s.GetDataRaw( ) != d.GetDataRaw( ) )
      << "FrVect" << std::endl;
  }

  //---------------------------------------------------------------------
  // FrameH
  //---------------------------------------------------------------------

  {
    stat_data_container_type	sd;
    make_frame_ret_type
      obj = ( makeFrameVersion( FRAME_SPEC_CURRENT, sd ) );

    FrameH* frame = dynamic_cast< FrameH* >( obj.get( ) );
    const long adc_count( frame->GetRawData( )->RefFirstAdc( )[0].use_count( ) );
    const long proc_count( frame->RefProcData( )[0].use_count( ) );

    FrameH	frame2( *frame );

    Test.Check( frame->GetRawData( ) != frame2.GetRawData( ) )
      << "frame::RawData" << std::endl;
    Test.Check( &(frame->GetRawData( )->RefFirstAdc( )) !=
		&(frame2.GetRawData( )->RefFirstAdc( )) )
      << "frame::RawData::firstAdc" << std::endl;
    Test.Check( frame2.GetRawData( )->RefFirstAdc( )[0].use_count( ) > adc_count )
      << "frame::RawData::firstAdc[0]"
      << std::endl
      ;
    Test.Check( frame2.RefProcData( )[0].use_count( ) > proc_count )
      << "frame::ProcData[0]"
      << std::endl
      ;
  }

  Test.Exit( );
 } catch ( const std::exception& Exception ) {
    Test.Check( false ) << "Caught an exception: "
			<< Exception.what( )
			<< std::endl;
    Test.Exit( );
} catch (...) {
  Test.Check( false ) << "Caught an exception" << std::endl;
  Test.Exit( );
}

