#ifndef FrameCPP_VERSION_8_FrTable_HH
#define FrameCPP_VERSION_8_FrTable_HH

#ifndef SWIGIMPORTED
#include <vector>
#endif /* SWIGIMPORTED */

#include "framecpp/Version8/FrameSpec.hh"

#include "framecpp/Common/SearchContainer.hh"

#include "framecpp/Version7/FrTable.hh"

#include "framecpp/Version8/PTR_STRUCT.hh"
#include "framecpp/Version8/FrVect.hh"
#include "framecpp/Version8/STRING.hh"

namespace FrameCPP
{
  namespace Version_8
  {
    //===================================================================
    //
    //===================================================================
    typedef Previous::FrTable::FrTableNPS FrTableNPS;

    //===================================================================
    //
    //===================================================================
    typedef Version_4::
    FrTablePST< PTR_STRUCT,
		Common::SearchContainer< FrVect, &FrVect::GetName > >
    FrTablePS;

    //===================================================================
    /// \brief Table Data Structure Definition
    //===================================================================
    class FrTable
      : public ObjectWithChecksum< Common::FrameSpec::Object >,
	public FrTableNPS,
	public FrTablePS
    {
    public:
      //-----------------------------------------------------------------
      /// \brief Default constructor
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrTable( );

      //-----------------------------------------------------------------
      /// \brief Copy Constructor
      ///
      /// \param[in] Source
      ///     The object from which to copy the information.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrTable( const FrTable& Source );

      //-----------------------------------------------------------------
      /// \brief Copy Constructor
      ///
      /// \param[in] Source
      ///     The object from which to copy the information.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrTable( const FrTableNPS& Source );

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] name
      ///     The of this table.
      /// \param[in] nrows
      ///     Number of rows in table.
      ///
      /// \return
      ///     A new instance of the object.
      //-----------------------------------------------------------------
      FrTable( const std::string& name, INT_4U nrows );

      //-----------------------------------------------------------------
      /// \brief Promotion Constructor
      ///
      /// \param[in] Source
      ///     An FrTable structure from a previous frame specification.
      /// \param[in] Stream
      ///     The stream from which the earliest version of the
      ///     FrTable structure was read.
      ///
      /// \return
      ///     A new instance of the object.
      //-----------------------------------------------------------------
      FrTable( Previous::FrTable& Source, Common::IStream* Stream );

      //-----------------------------------------------------------------
      /// \brief Destructor
      //-----------------------------------------------------------------
      virtual ~FrTable( );

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      virtual const char* ObjectStructName( ) const;

      //-----------------------------------------------------------------
      /// \brief Retrieve the name of the table.
      ///
      /// \return
      ///     The name of the table.
      //-----------------------------------------------------------------
      const std::string& GetNameSlow( ) const;

      //-----------------------------------------------------------------
      /// \brief Merge with another FrTable
      ///
      /// \param[in] RHS
      ///     The source of the information to append to this FrTable
      ///     structure.
      ///
      /// \return
      ///     A reference to this object
      //-----------------------------------------------------------------
      FrTable& Merge( const FrTable& RHS );

      //-----------------------------------------------------------------
      /// \brief Concatinate with another FrTable
      ///
      /// \param[in] RHS
      ///     The source of the information to append to this FrTable
      ///     structure.
      ///
      /// \return
      ///     A reference to this object
      //-----------------------------------------------------------------
      FrTable& operator+=( const FrTable& RHS );

      //-----------------------------------------------------------------
      /// \brief Promote previous version of object to this version
      ///
      /// \param[in] Source
      ///     The frame specification version of the object.
      /// \param[in] Obj
      ///     The previous version of the object.
      /// \param[in] Stream
      ///     Stream from which the origional object was created.
      ///
      /// \return
      ///     A new instance of FrameH based on Obj
      //-----------------------------------------------------------------
      static promote_ret_type
      Promote( INT_2U Source,
	       promote_arg_type Obj,
	       Common::IStream* Stream );

      //-----------------------------------------------------------------
      /// \brief Dictionary class id for this structure.
      //-----------------------------------------------------------------
      static const Common::FrameSpec::Info::frame_object_types CLASS_ID
      = Common::FrameSpec::Info::FSI_FR_TABLE;

      //-----------------------------------------------------------------
      /// \brief The description of structure
      ///
      /// \return
      ///     A Description object which describes this structure as
      ///     specified by the frame specification.
      //-----------------------------------------------------------------
      static const Common::Description* StructDescription( );

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      static const char* StructName( );

      //-----------------------------------------------------------------
      /// \brief equality operator
      ///
      /// \param[in] RHS
      ///     The FrTable object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      bool operator==( const FrTable& RHS ) const;

      //-----------------------------------------------------------------
      /// \brief equality operator for abstract data type
      ///
      /// \param[in] RHS
      ///     The object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      virtual bool operator==( const Common::FrameSpec::Object& RHS ) const;

    protected:
      //-----------------------------------------------------------------
      /// \brief Demotes object to previous version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the frame specification to demote too.
      /// \param[in] Obj
      ///     The version of the object to demote.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object of the previous generation.
      //-----------------------------------------------------------------
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Promotes object to another version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the promoted frame specification.
      /// \param[in] Obj
      ///     The object to be promoted.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object promoted to the next generation.
      //-----------------------------------------------------------------
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Number of bytes needed to write this structure
      ///
      /// \param[in] Stream
      ///     The stream from which to the object is being read or
      ///     written.
      ///
      /// \return
      ///     The number of bytes need to read or write this object.
      //-----------------------------------------------------------------
      virtual cmn_streamsize_type
      pBytes( const Common::StreamBase& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Virtual constructor
      ///
      /// \param[in] Stream
      ///     The input stream from where the object is being read.
      //-----------------------------------------------------------------
      virtual FrTable* pCreate( Common::IStream& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Write the structure to the stream
      ///
      /// \param[in] Stream
      ///     The output stream where the object is to be written.
      //-----------------------------------------------------------------
      virtual void pWrite( Common::OStream& Stream ) const;

    private:
      //-----------------------------------------------------------------
      /// \brief Object with checksum data.
      //-----------------------------------------------------------------
      typedef ObjectWithChecksum< Common::FrameSpec::Object > object_type;

      using Common::FrameSpec::Object::Create;

      //-----------------------------------------------------------------
      /// \brief Stream Constructor
      ///
      /// \param[in] Stream
      ///     The stream from which the object is being read.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrTable( Common::IStream& Stream );
    };

    //-------------------------------------------------------------------
    /// \brief Tests the equality of two tables.
    ///
    /// \param[in] RHS
    ///     Right hand side of equality expression.
    ///
    /// \return
    ///     True if the two tables are equivelant, false otherwise.
    //-------------------------------------------------------------------
    inline bool FrTable::
    operator==( const FrTable& RHS ) const
    {
      return ( m_data == RHS.m_data );
    }

    inline FrTable::promote_ret_type FrTable::
    Promote( INT_2U Source,
	     promote_arg_type Obj,
	     Common::IStream* Stream )
    {
      return Object::PromoteObject< Previous::FrTable, FrTable >
	( DATA_FORMAT_VERSION, Source, Obj, Stream );
    }

    //-------------------------------------------------------------------
    /// The name of the structure is most often used when writing the
    /// description of the structure out to a stream.
    ///
    /// \return
    ///     The name of the structure.
    //-------------------------------------------------------------------
    inline const char* FrTable::
    StructName( )
    {
      static const CHAR* class_name( "FrTable" );
      return class_name;
    }

  } // namespace - Version_8
} // namespace FrameCPP
#endif /* FrameCPP_VERSION_8_FrTable_HH */

