#include "framecpp/Common/Description.hh"
#include "framecpp/Common/TOCInfo.hh"

#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"
#include "framecpp/Version8/FrTOC.hh"

#include "framecpp/Version8/STRING.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::TOCInfo;

namespace FrameCPP
{
  namespace Version_8
  {
    //===================================================================
    //===================================================================
    FrTOCStatData::
    FrTOCStatData( )
    {
    }

    FrTOCStatData::
    FrTOCStatData( Common::IStream& Stream )
    {
      nstat_type	nstat;
      Stream >> nstat;
      if ( nstat && ( nstat != FrTOC::NO_DATA_AVAILABLE ) )
      {
	std::vector< name_type >		names( nstat );
	std::vector< detector_type >		detectors( nstat );
	std::vector< nstat_instance_type >	nstatinstances( nstat );
	nstat_type				ntotalstat;

	Stream >> names
	       >> detectors
	       >> nstatinstances
	       >> ntotalstat
	  ;

	std::vector< tstart_type >		tstart( ntotalstat );
	std::vector< tend_type >		tend( ntotalstat );
	std::vector< version_type >		version( ntotalstat );
	std::vector< positionStat_type >	position( ntotalstat );

	Stream >> tstart
	       >> tend
	       >> version
	       >> position
	  ;

	//---------------------------------------------------------------
	// Fill in the structure
	//---------------------------------------------------------------
	m_info.erase( m_info.begin( ), m_info.end( ) );
	INT_4U	offset = 0;
	INT_4U	suboffset = 0;
	for ( std::vector< name_type >::const_iterator
		cur_name = names.begin( ),
		last_name = names.end( );
	      cur_name != last_name;
	      ++cur_name )
	{
	  stat_type& s( m_info[ *cur_name ] );

	  //-------------------------------------------------------------
	  // Fill in the static data core
	  //-------------------------------------------------------------
	  s.detector = detectors[ offset ];
	  //-------------------------------------------------------------
	  // Fill in the version specific information
	  //-------------------------------------------------------------
	  if ( nstatinstances[ offset ] )
	  {
	    s.stat_instances.resize( nstatinstances[ offset ] );
	    for ( nstat_type x = 0,
		    x_end = nstatinstances[ offset ];
		  x != x_end;
		  ++x )
	    {
	      s.stat_instances[ x ].tStart = tstart[ suboffset ];
	      s.stat_instances[ x ].tEnd = tend[ suboffset ];
	      s.stat_instances[ x ].version = version[ suboffset ];
	      s.stat_instances[ x ].positionStat = position[ suboffset ];
	      ++suboffset;
	    }
		  
	  }
	  ++offset;
	}
      }
      else
      {
	nstat_type	tstat;
	
	Stream >> tstat;
      }

    }

    void FrTOCStatData::
    QueryStatData( const Common::TOCInfo& Info,
		   INT_4U FrameOffset,
		   INT_8U Position )
    {
      STRING	name;
      STRING	detector;
      INT_4U	start;
      INT_4U	end;
      INT_4U	version;

      Info.TOCQuery( TOCInfo::IC_NAME, TOCInfo::DataType( name ), &name,
		     TOCInfo::IC_DETECTOR, TOCInfo::DataType( detector ),
		     &detector,
		     TOCInfo::IC_START, TOCInfo::DataType( start ), &start,
		     TOCInfo::IC_END, TOCInfo::DataType( end ), &end,
		     TOCInfo::IC_VERSION, TOCInfo::DataType( version ),
		     &version,
		     TOCInfo::IC_EOQ );

      stat_instance_type si;

      si.tStart = start;
      si.tEnd = end;
      si.version = version;
      si.positionStat = Position;

      stat_type& i( m_info[ name ] );
      if ( ( i.detector.length( ) )
	   && ( i.detector != detector ) )
      {
	std::ostringstream msg;

	msg << "FrStatData with the name '" << name
	    << "' is associated with detector '" << i.detector
	    << "' and detector '" << detector << "'"
	  ;
	throw std::runtime_error( msg.str( ) );
      }
      i.detector = detector;
      i.stat_instances.push_back( si );
    }

    void FrTOCStatData::
    write( Common::OStream& Stream ) const
    {
      if ( m_info.size( ) > 0 )
      {
	//---------------------------------------------------------------
	// Flatten the strucutres.
	//---------------------------------------------------------------

	nstat_type			offset( 0 );

	std::vector< name_type >	names( m_info.size( ) );
	std::vector< detector_type >	detectors( m_info.size( ) );
	std::vector< nstat_type >	nstatinstances( m_info.size( ) );
	nstat_type			ntotalstat = 0;

	std::vector< tstart_type >		tstart;
	std::vector< tend_type >		tend;
	std::vector< version_type >		version;
	std::vector< positionStat_type >	position;

	for ( stat_container_type::const_iterator
		cur = m_info.begin( ),
		last = m_info.end( );
	      cur != last;
	      ++cur, ++offset )
	{
	  names[ offset ] = cur->first;
	  detectors[ offset ] = cur->second.detector;
	  nstatinstances[ offset ] = cur->second.stat_instances.size( );
	  ntotalstat += cur->second.stat_instances.size( );
	  for ( stat_instance_container_type::const_iterator
		  cur_instance = cur->second.stat_instances.begin( ),
		  last_instance = cur->second.stat_instances.end( );
		cur_instance != last_instance;
		++cur_instance )
	  {
	    tstart.push_back( cur_instance->tStart );
	    tend.push_back( cur_instance->tEnd );
	    version.push_back( cur_instance->version );
	    position.push_back( cur_instance->positionStat );
	  }
	}

	Stream << nstat_type( m_info.size( ) )
	       << names
	       << detectors
	       << nstatinstances
	       << ntotalstat
	       << tstart
	       << tend
	       << version
	       << position
	  ;
      }
      else
      {
#if WORKING
	Stream << nstat_type( FrTOC::NO_DATA_AVAILABLE );
#else /* WORKING */
	Stream << nstat_type( 0 ); // nStatType
	Stream << nstat_type( 0 ); // nTotalStat
#endif
      }
    }

  } // namespace - Version_8
} // namespace - FrameCPP
