#include <ldas_tools_config.h>

#include <memory>

#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/FrameSpec.tcc"

#include "framecpp/Version8/FrameSpec.hh"

#include "framecpp/Version8/FrSE.hh"

using FrameCPP::Common::FrameSpec;

using FrameCPP::Common::Description;
using FrameCPP::Common::IStream;
using FrameCPP::Common::OStream;
using namespace FrameCPP::Version_8;

static const Description* s_description = (Description*)NULL;

FrSE::
FrSE( )
  : object_type( s_object_id, s_description )
{
  m_data.name = "";
  m_data.classId = "";
  m_data.comment = "";
}

FrSE::
FrSE( const std::string& Name,
      const std::string& ClassId,
      const std::string& Comment )
  : object_type( s_object_id, s_description )
{
  m_data.name = Name;
  m_data.classId = ClassId;
  m_data.comment = Comment;
}

FrSE::
FrSE( Common::IStream& Stream )
  : object_type( s_object_id, s_description )
{
  Stream >> m_data.name
	 >> m_data.classId
	 >> m_data.comment
    ;
}

FrSE::
~FrSE( )
{
}

const char* FrSE::
ObjectStructName( ) const
{
  return StructName( );
}

std::string FrSE::
GetName( ) const
{
   return m_data.name;
}


FrSE* FrSE::
Clone( ) const
{
  return new FrSE( *this );
}

bool FrSE::
operator==( const FrSE& RHS ) const
{
  return ( ( m_data.name == RHS.m_data.name )
	   && ( m_data.classId == RHS.m_data.classId )
	   && ( m_data.comment == RHS.m_data.comment ) );
}

bool FrSE::
operator==( const Common::FrameSpec::Object& Obj ) const
{
  return ( *this == Obj );
}

FrSE::demote_ret_type FrSE::
demote( INT_2U Target,
	demote_arg_type Obj,
	Common::IStream* Stream ) const
{
  throw
    Unimplemented( "Object* FrSE::Demote( Object* Obj ) const",
		   DATA_FORMAT_VERSION, __FILE__, __LINE__ );
}

FrSE::promote_ret_type FrSE::
promote( INT_2U Target,
	 promote_arg_type Obj,
	 Common::IStream* Stream ) const
{
  throw
    Unimplemented( "Object* FrSE::Promote( Object* Obj ) const",
		   DATA_FORMAT_VERSION, __FILE__, __LINE__ );
}

INT_8U FrSE::
pBytes( const Common::StreamBase& Stream ) const
{
  return
    m_data.name.Bytes( ) +
    m_data.classId.Bytes( ) +
    m_data.comment.Bytes( );
}

FrSE* FrSE::
pCreate( Common::IStream& Stream ) const
{
  return new FrSE( Stream );
}

void FrSE::
pWrite( Common::OStream& Stream ) const
{
  Stream << m_data.name
	 << m_data.classId
	 << m_data.comment
    ;
}
