#include <ldas_tools_config.h>

#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/FrameStream.hh"
#include "framecpp/Common/CheckSumFilter.hh"
#include "framecpp/Common/Description.hh"
#include "framecpp/Common/FrameSpec.tcc"

#include "framecpp/Version8/FrEndOfFrame.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"

#include "framecpp/Common/Promotion.hh"

using FrameCPP::Common::CheckSum;
using FrameCPP::Common::CheckSumFilter;
using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::OFrameStream;


static const FrameSpec::Info::frame_object_types s_object_id
= FrameSpec::Info::FSI_FR_END_OF_FRAME;

namespace FrameCPP
{
  namespace Version_8
  {
    FrEndOfFrame::
    FrEndOfFrame( )
      : object_type( s_object_id, StructDescription( ) )
    {
    }

    FrEndOfFrame::
    FrEndOfFrame( INT_4S Run, INT_4U Frame )
      : object_type( s_object_id, StructDescription( ) )
    {
      m_data.run = Run;
      m_data.frame = Frame;
    }

    FrEndOfFrame::
    FrEndOfFrame( istream_type& Stream )
      : object_type( s_object_id, StructDescription( ) )
    {
      GTimeS_type	sec;
      GTimeN_type	nsec;

      Stream
	>> m_data.run
	>> m_data.frame
	>> sec
	>> nsec
	;
      m_data.GTime = GPSTime( sec, nsec );
    }

    FrEndOfFrame::
    ~FrEndOfFrame( )
    {
    }

    const char* FrEndOfFrame::
    ObjectStructName( ) const
    {
      return StructName( );
    }

    const Description* FrEndOfFrame::
    StructDescription( )
    {
      static Description ret;

      if ( ret.size( ) == 0 )
      {
	ret( FrSH( "FrEndOfFrame", s_object_id,
		   "End of Frame Data Structure" ) );
	ret( FrSE( "run", "INT_4S",
		   "Run number; same as in FrameHeader run number datum." ) );
	ret( FrSE( "frame", "INT_4U",
		   "Frame number, monotonically increasing until end of run;"
		   " same as in Frame Header run number datum" ) );
	ret( FrSE( "GTimeS", "INT_4U",
		   "Frame start time in GPS Seconds." ) );
	ret( FrSE( "GTimeN", "INT_4U",
		   "Frame start time residual, integer nanoseconds." ) );

	ret( FrSE( "chkSum", CheckSumDataClass( ), CheckSumDataComment( ) ) );
      }

      return &ret;
    }

    bool FrEndOfFrame::
    operator==( const FrEndOfFrame& RHS ) const
    {
      return ( ( m_data.run == RHS.m_data.run )
	       && ( m_data.frame == RHS.m_data.frame )
	       && ( m_data.GTime == RHS.m_data.GTime ) );
    }

    bool FrEndOfFrame::
    operator==( const Common::FrameSpec::Object& RHS ) const
    {
      return ( *this == RHS );
    }

    FrEndOfFrame::demote_ret_type FrEndOfFrame::
    demote( INT_2U Target,
	    demote_arg_type Obj,
	    istream_type* Stream ) const
    {
      throw
	Unimplemented( "Object* FrEndOfFrame::demote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrEndOfFrame::promote_ret_type FrEndOfFrame::
    promote( INT_2U Target,
	     promote_arg_type Obj,
	     istream_type* Stream ) const
    {
      throw
	Unimplemented( "Object* FrEndOfFrame::promote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrameCPP::cmn_streamsize_type FrEndOfFrame::
    pBytes( const Common::StreamBase& Stream ) const
    {
      return
	sizeof( m_data.run )
	+ sizeof( m_data.frame )
	+ sizeof( GTimeS_type )
	+ sizeof( GTimeN_type )
	;
    }

    FrEndOfFrame* FrEndOfFrame::
    pCreate( istream_type& Stream ) const
    {
      return new FrEndOfFrame( Stream );
    }

    void FrEndOfFrame::
    pWrite( ostream_type& Stream ) const
    {
      //---------------------------------------------------------------------
      // Write out to the stream
      //---------------------------------------------------------------------
      Stream
	<< m_data.run
	<< m_data.frame
	<< GTimeS_type( m_data.GTime.GetSeconds( ) )
	<< GTimeN_type( m_data.GTime.GetNanoseconds( ) )
	;
    }
  } // namespace - Version_8
} // namespace - FrameCPP
