#ifndef FrameCPP_VERSION_4_FrTOCPosition_HH
#define FrameCPP_VERSION_4_FrTOCPosition_HH

#include "framecpp/Version4/STRING.hh"

namespace FrameCPP
{
  namespace Common
  {
    class TOCInfo;
  }

  namespace Version_4
  {
    //===================================================================
    //===================================================================
    class FrTOCPosition
    {
    public:
      Common::FrameSpec::size_type
      Bytes( const Common::StreamBase& Stream ) const;

      typedef INT_4U	n_type;
      typedef STRING	name_type;
      typedef INT_8U	position_type;

      typedef std::vector< position_type > info_type;
      typedef std::map< name_type, info_type >
      Map_type;
      typedef std::vector< name_type > key_container_type;

      const key_container_type& GetPositionKeys( ) const;

      const FrTOCPosition& operator=( const FrTOCPosition& Source );

    protected:
      key_container_type	m_keys;
      Map_type			m_info;

      FrTOCPosition( );

      FrTOCPosition( Common::IStream& Stream, INT_4U FrameCount );

      const Map_type& getInfo( ) const;

      Map_type::const_iterator getInfo( const std::string& Name ) const;

      Map_type::const_iterator getInfo( INT_4U Index ) const;

      bool operator==( const FrTOCPosition& RHS ) const;

      void write( Common::OStream& Stream ) const;
    };

    inline FrTOCPosition::
    FrTOCPosition( )
    {
    }

    inline FrTOCPosition::
    FrTOCPosition( Common::IStream& Stream, INT_4U FrameCount )
    {
      n_type	n;
      Stream >> n;
      if ( n && ( n != ~n_type( 0 ) ) )
      {
	//---------------------------------------------------------------
	// Read in the information
	//---------------------------------------------------------------
	key_container_type::size_type	s( n );
	std::vector< position_type >	positions( s * FrameCount );

	m_keys.resize( s );

	Stream >> m_keys
	       >> positions
	  ;
	//---------------------------------------------------------------
	// Move into structure.
	//---------------------------------------------------------------
	std::vector< position_type >::const_iterator
	  cur_position = positions.begin( );

	for ( key_container_type::const_iterator
		cur = m_keys.begin( ),
		last = m_keys.end( );
	      cur != last;
	      ++cur,
		cur_position += FrameCount )
	{
	  info_type& i = m_info[ *cur ];
	  i.assign( cur_position, cur_position + FrameCount );
	}
      }
    }

    inline Common::FrameSpec::size_type FrTOCPosition::
    Bytes( const Common::StreamBase& Stream ) const
    {
      Common::FrameSpec::size_type 
	retval = sizeof( n_type );
      if ( m_info.size( ) )
      {
	retval
	  += ( m_info.size( )
	       * ( sizeof( position_type )
		   * m_info.begin( )->second.size( )
		   ) );
      }
      for ( Map_type::const_iterator
	      cur = m_info.begin( ),
	      last = m_info.end( );
	    cur != last;
	    ++cur )
      {
	retval += cur->first.Bytes( );
      }
      return retval;
    }

    inline const FrTOCPosition::key_container_type& FrTOCPosition::
    GetPositionKeys( ) const
    {
      return m_keys;
    }

    inline const FrTOCPosition& FrTOCPosition::
    operator=( const FrTOCPosition& Source )
    {
      m_keys = Source.m_keys;
      m_info = Source.m_info;

      return *this;
    }

    inline const FrTOCPosition::Map_type& FrTOCPosition::
    getInfo( ) const
    {
      return m_info;
    }

    inline FrTOCPosition::Map_type::const_iterator FrTOCPosition::
    getInfo( const std::string& Channel ) const
    {
      return getInfo( ).find( Channel );
    }

    inline FrTOCPosition::Map_type::const_iterator FrTOCPosition::
    getInfo( INT_4U Channel ) const
    {
      const FrTOCPosition::Map_type&
	i( getInfo( ) );

      if ( Channel >= i.size( ) )
      {
	return i.end( );
      }
      return i.find( m_keys[ Channel ] );
    }

    inline void FrTOCPosition::
    write( Common::OStream& Stream ) const
    {
      //-----------------------------------------------------------------
      // Flatten data so it is streamable
      //-----------------------------------------------------------------
      std::vector< name_type >::size_type	s( m_info.size( ) );
      if ( s )
      {
	std::vector< name_type >::size_type
	  fc( m_info.begin( )->second.size( ) );


	std::vector< name_type >	names( s );
	std::vector< position_type >	positions( s * fc );
	//---------------------------------------------------------------
	// Copy data for streaming
	//---------------------------------------------------------------
	std::vector< name_type >::iterator
	  cur_name = names.begin( );
	std::vector< position_type >::iterator
	  cur_position = positions.begin( );

	for ( Map_type::const_iterator
		cur = m_info.begin( ),
		last = m_info.end( );
	      cur != last;
	      ++cur, ++cur_name,
		cur_position += fc )
	{
	  *cur_name = cur->first;
	  std::copy( cur->second.begin( ),
		     cur->second.end( ),
		     cur_position );
	}
	//---------------------------------------------------------------
	// Stream out
	//---------------------------------------------------------------
	Stream << n_type( s )
	       << names
	       << positions
	  ;

      }
      else
      {
	Stream << ~n_type( 0 );
      }
    }
  } // namespace - Version_4
} // namespace - FrameCPP

#endif /* FrameCPP_VERSION_4_FrTOCPosition_HH */
