/* -*- mode: c++ -*- */

%module frameCPP

%{
#include "ldastoolsal/types.hh"
#include "framecpp/Dimension.hh"

using namespace FrameCPP;
%}

%import "framecpp/Dimension.hh"

%include "ldastoolsal/SharedPtr.i"

%include "Container.i"

%SharedPtr(Dimension)

%feature("docstring")
  Dimension
  "The Dimension class describes a single dimension information of
   a single or multiple dimensional array."

class Dimension
{
public:
  typedef DIMENSION_NDIM_TYPE	nDim_type;
  typedef DIMENSION_NX_TYPE	nx_type;
  typedef DIMENSION_DX_TYPE	dx_type;
  typedef DIMENSION_STARTX_TYPE	startX_type;

  Dimension( );

  Dimension( nx_type Nx, dx_type Dx, const char* UnitX, startX_type StartX );

  nx_type GetNx( ) const;
   
  dx_type GetDx( ) const;
      
  startX_type GetStartX( ) const;

  //---------------------------------------------------------------------
  /// \brief Retrieve the description of how to interpret each element
  ///
  /// \return
  ///     The description of how to interpret each element
  //---------------------------------------------------------------------
  const std::string& GetUnitX( ) const;

  void SetDx( dx_type Dx );
      
  void SetNx( nx_type Nx );
   
  void SetStartX( startX_type StartX );

  LDAS_PROPERTY_READ_ONLY("nx",GetNx)
  LDAS_PROPERTY_READ_ONLY("dx",GetDx)
  LDAS_PROPERTY_READ_ONLY("startX",GetStartX)
  LDAS_PROPERTY_READ_ONLY("unitX",GetUnitX)
};
