#include <ldas_tools_config.h>

#include <sstream>
#include <stdexcept>

#include "framecpp/Common/DetectorNames.hh"

namespace FrameCPP
{
  namespace Common
  {
    //-------------------------------------------------------------------
    /// The default constructor is used to ensure proper initialization
    /// of the data elements.
    //-------------------------------------------------------------------
    DetectorNames::
    DetectorNames( )
      : m_frozen( false )
    {
    }

    //-------------------------------------------------------------------
    /// This method retrieves information about a detector.
    //-------------------------------------------------------------------
    const DetectorNames::info_type& DetectorNames::
    Detector( const std::string& Name ) const
    {
      detector_info_container_type::const_iterator
	pos = m_info.find( Name );

      if ( pos == m_info.end( ) )
      {
	//---------------------------------------------------------------
	/// \exception std::range_error
	///     This exception is thrown if the Name parameter does
	///     not reference an entry in the set of detectors.
	//---------------------------------------------------------------
	std::ostringstream	msg;

	msg << "Unable to locate the detector named " << Name
	  ;
	throw std::range_error( msg.str( ) );
      }
      return pos->second;
    }

    //-------------------------------------------------------------------
    /// This adds detector infomation into the set of known detectors.
    /// This routine is intended to be used by the version specific
    /// initialization routine.
    //-------------------------------------------------------------------
    void DetectorNames::
    operator()( const std::string& DetectorName,
		const std::string& Detector,
		const std::string& Prefix,
		const std::pair< int, int > DataQualityBits )
    {
      if ( m_frozen == false )
      {
	info_type&	d( m_info[ DetectorName ] );

	d.s_detector = Detector;
	d.s_prefix = Prefix;
	d.s_data_quality_bits = DataQualityBits;
      }
    }
  } // namespace - Common
} // namespace - FrameCPP
