#include <ldas_tools_config.h>

#include "diskcacheAPI/Streams/ASCII.hh"
#include "diskcacheAPI/Streams/Binary.hh"

#include "diskcacheAPI/Cache/SDGTxStreamASCII.hh"
#include "diskcacheAPI/Cache/SDGTxStreamBinary.hh"

#include "diskcache.hh"
#include "diskcacheAPI.hh"

using LDASTools::AL::MutexLock;

namespace diskCache
{
  //-----------------------------------------------------------------------------
  // Number of micro seconds to allow for lock acquisition
  // int RWLOCK_TIMEOUT = 10000;
  //-----------------------------------------------------------------------------
  int RWLOCK_TIMEOUT = 0;

  //-----------------------------------------------------------------------------
  /// This variable specifies the number of milliseconds to delay between
  /// successive scans of the list of mount points.
  ///
  /// The default value is 500 ( 0.5 sec. ).
  //-----------------------------------------------------------------------------
  INT_4U ScanInterval = 500;

  //-----------------------------------------------------------------------------
  /// The runtime initialization of the core ensures that many of the callback
  /// tables for various classes are properly initialized
  //-----------------------------------------------------------------------------
  void
  Initialize( )
  {
    typedef diskCache::Common::Registry::AlreadyRegisteredException
      AlreadyRegisteredException;

    diskCache::Cache::RegistrySingleton::id_type
      sdgtx_id( diskCache::Cache::RegistrySingleton::KEY_NULL );

    try
    {
      sdgtx_id = diskCache::Cache::SDGTx::RegisterSearchEngine( );
    }
    catch( const AlreadyRegisteredException& Exception )
    {
      sdgtx_id = Exception.Id( );
    }
    //---------------------------------------------------------------------
    // Initialize ascii stream callbacks
    //---------------------------------------------------------------------
    Streams::OASCII::Writer( sdgtx_id,
			     Cache::SDGTxDirectoryInfoToOASCII );
    //---------------------------------------------------------------------
    // Initialize binary stream callbacks
    //---------------------------------------------------------------------
    Streams::IBinary::Reader( sdgtx_id,
			      Cache::SDGTxDirectoryInfoFromIBinary );
    Streams::OBinary::Writer( sdgtx_id,
			      Cache::SDGTxDirectoryInfoToOBinary );
    //---------------------------------------------------------------------
    // Initialize indexing scheme
    //---------------------------------------------------------------------

  }

  static MutexLock::baton_type  p_scanned_files_baton;
  static total_file_count_type	p_scanned_files = 0;

  total_file_count_type
  ScannedFiles( )
  {
    MutexLock      lock( p_scanned_files_baton,
			 __FILE__, __LINE__ );

    return p_scanned_files;
  }

  void
  ScannedFiles( total_file_count_type Value )
  {
    MutexLock      lock( p_scanned_files_baton,
			 __FILE__, __LINE__ );

    if ( Value == SCANNED_FILES_RESET )
    {
      p_scanned_files = 0;
    }
    else
    {
      p_scanned_files += Value;
    }
  }
 }
