#ifndef DISCKCACHE__SERVER_INTERFACE_I
#define DISCKCACHE__SERVER_INTERFACE_I

%include "std_string.i"

%{
#include <ldas_tools_config.h>

#include <stdexcept>

#include "ldastoolsal/ldasexception.hh"

#include "genericAPI/swigexception.hh"

#include "diskcacheAPI/ServerInterface.hh"

  using diskCache::ServerInterface;

 typedef ServerInterface::filenames_rds_results_type filenames_rds_results_type;
 typedef ServerInterface::time_type time_type;
 typedef ServerInterface::port_type port_type;

%}

%include "ServerInterface_typemaps_python.i"

class ServerInterface
{
 public:
  static std::string DEFAULT_EXTENSION;

  void FilenamesRDS( filenames_rds_results_type& Results,
		     const std::string& IFO,
		     const std::string& Desc,
		     time_type StartTime,
		     time_type EndTime,
		     bool Resample,
		     const std::string& Extension );

  void Server( const std::string& Host, port_type Port );
};

#endif /* DISCKCACHE__SERVER_INTERFACE_I */
