/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef LDASTOOLSAL__TASK_TIMER_HH
#define LDASTOOLSAL__TASK_TIMER_HH

#include "ldastoolsal/Task.hh"

namespace LDASTools
{
  namespace AL
  {
    //-------------------------------------------------------------------
    /// \brief Give a task a maximum amount of time to complete
    ///
    /// This class ensures that a task completes within a given amount
    /// of time.
    /// If the task does not complete, the it is canceled using the
    /// registered cancellation signal.
    //-------------------------------------------------------------------
    class Timer
      : public Task
    {
    public:
      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] Seconds
      ///     Number of seconds to allow task to complete
      ///
      /// \param[in] CancelSignal
      ///     Signal to use to cancel this timer.
      //-----------------------------------------------------------------
      Timer( int Seconds, signal_type CancelSignal = 0 );
      //-----------------------------------------------------------------
      /// \brief Action
      //-----------------------------------------------------------------
      virtual void operator()( );
      //-----------------------------------------------------------------
      /// \brief True if time ran out for the process to complete.
      //-----------------------------------------------------------------
      bool Error( ) const;

    private:
      int	m_timeout;
      bool	m_err;
    };
  } // namespace - AL
} // namespace - LDASTools

#endif /* LDASTOOLSAL__TASK_TIMER_HH */
