/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef LDASTOOLSAL__SYSTEM_CALL_TASK_HH
#define LDASTOOLSAL__SYSTEM_CALL_TASK_HH

#include "ldastoolsal/SystemCall.hh"
#include "ldastoolsal/Task.hh"

namespace LDASTools
{
  namespace AL
  {
    //-------------------------------------------------------------------
    /// \brief Perform a system call within a thread
    ///
    /// This is an abstract class that should be used as the base
    /// for a class that is to perform some system call usually within
    /// a thread.
    //-------------------------------------------------------------------
    class SystemCallTask
      : public SystemCall,
	public Task
    {
    public:
      //-----------------------------------------------------------------
      /// \brief Constructor
      //-----------------------------------------------------------------
      SystemCallTask( );

    protected:
      //-----------------------------------------------------------------
      /// \brief Action to be performed
      //-----------------------------------------------------------------
      virtual int eval( ) = 0;

    private:
      virtual void operator()( );
    };
  } // namespace - AL
} // namespace - LDASTools

#endif /* LDASTOOLSAL__SYSTEM_CALL_TASK_HH */
