#include "ldastoolsal/Config.hh"

#include <algorithm>
#include <functional>
#include <iostream>
#include <locale>
#include <string>
#include <sstream>

namespace
{
  static inline std::string&
  ltrim( std::string& s )
  {
    s.erase( s.begin( ),
	     std::find_if( s.begin( ),
			   s.end( ),
			   std::not1( std::ptr_fun<int,int>( std::isspace ) ) ) );
    return s;
  }

  static inline std::string&
  rtrim( std::string& s )
  {
    s.erase( std::find_if( s.rbegin( ),
			   s.rend( ),
			   std::not1( std::ptr_fun<int, int>( std::isspace ) ) ).base( ),
	     s.end( ) );
    return s;
  }

  static inline std::string&
  trim( std::string& s )
  {
    return ltrim( rtrim( s ) ) ;
  }
}

namespace LDASTools
{
  namespace AL
  {
    Config::
    Config( )
    {
    }

    void Config::
    Parse( std::istream& Stream )
    {
      std::string	line;

      while( std::getline( Stream, line ) )
      {
	line = trim( line );
	std::string::size_type	pos;

	if ( ( *(line.begin( )) == '[' )
	     && ( *(line.end( ) - 1) == ']' ) )
	{
	  line = line.substr( 1, line.size( ) - 2);
	  line = trim( line );
	  ParseBlock( line );
	}
	else if ( ( pos = line.find( '=' ) ) != std::string::npos )
	{
	  std::istringstream	is_line( trim( line ) );
	  std::string		key;
	  std::string		value;

	  std::getline( is_line, key, '=' );
	  std::getline( is_line, value );
	  ParseKeyValue( trim( key ), trim( value ) );
	}
	else
	{
	  ParseWord( line );
	}
      }
    }
  }
}
