#ifndef GENERIC_API__STAT_HH
#define GENERIC_API__STAT_HH

struct stat;

namespace GenericAPI
{
  //---------------------------------------------------------------------
  /// \brief Query the interupt value
  //---------------------------------------------------------------------
  int lstat_interupt( );

  //---------------------------------------------------------------------
  /// \brief Query the timeout value
  //---------------------------------------------------------------------
  int lstat_timeout( );

  //---------------------------------------------------------------------
  /// \brief Establish the timeout value
  //---------------------------------------------------------------------
  int SetStatTimeout( int Value );

  //---------------------------------------------------------------------
  /// \brief Perform timed stat call
  //---------------------------------------------------------------------
  int Stat( const std::string& Filename, struct stat& StatBuffer );

  //---------------------------------------------------------------------
  /// \brief Perform timed lstat call
  //---------------------------------------------------------------------
  int LStat( const std::string& Filename, struct stat& StatBuffer );

  inline int
  lstat_interupt( )
  {
    extern int init_lstat_interupt( );

    static const int retval = init_lstat_interupt( );

    return retval;
  }
}

#endif /* GENERIC_API__STAT_HH */
