#include <fcntl.h>
#include <unistd.h>

#include <cstdio>
#include <cstdarg>
#include <ctime>
#include <cstring>

#include "ldas/ldasconfig.hh"

#include "ldastoolsal/AtExit.hh"

#include "framecpp/Common/FrameSpec.hh"
#include "framecpp/Common/CheckSum.hh"
#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/FrameStream.hh"
#include "framecpp/Common/FrameBuffer.hh"

#include "framecpp/FrameCPP.hh"

#include "framecpp/FrameH.hh"
#include "framecpp/FrAdcData.hh"
#include "framecpp/FrHistory.hh"
#include "framecpp/FrRawData.hh"
#include "framecpp/FrVect.hh"

#include "framecpp/Dimension.hh"
using namespace std;

using LDASTools::AL::GPSTime;

using LDASTools::AL::AutoArray;
using LDASTools::AL::SharedPtr;

int num_channels = 1;
   
SharedPtr< FrameCPP::FrRawData > rawData;

SharedPtr<FrameCPP::FrameH>
full_frame(int foo, long bar, int frame_length_seconds)
{
  rawData = SharedPtr< FrameCPP::FrRawData > (new FrameCPP::FrRawData);
  SharedPtr<FrameCPP::FrameH> frame;
  FrameCPP::FrHistory history ("", 0, "framebuilder, framecpp-" + string(LDAS_VERSION));
  frame = SharedPtr<FrameCPP::FrameH> (new FrameCPP::FrameH ("LIGO",
					     0, // run number ??? buffpt -r> block_prop (nb) -> prop.run;
					     1, // frame number
					     FrameCPP::Version::GPSTime (0, 0),
					     0, // leap seconds
					     frame_length_seconds // dt
					     ));
  frame->SetRawData (rawData);

  for (int i = 0; i <  num_channels; i++) {
    char buf[128]; sprintf(buf, "%d", i);
    SharedPtr<FrameCPP::FrAdcData> 
	 adc(new FrameCPP::FrAdcData (buf,
					  1,
					  i, // channel ???
					  8 * 32,
					  1024,
					  0,
					  0,
					  std::string(""),
					  0,
					  0,
					  0,
					  .0)); /* heterodyning phase in radians */
	        adc->SetDataValid( 0 );

      if (1) {
	//---------------------------------------------------------------
	// Commenting out this section fixes things
	//---------------------------------------------------------------
        int DATA_SET_SIZE = 16 * frame_length_seconds;

        /* Append ADC AUX vector to store 16 status words per second */
        FrameCPP::Dimension aux_dims[1]
          = { FrameCPP::Dimension (16 * frame_length_seconds,
                                              1. / 16,
                                              "") };
        AutoArray< REAL_8 > data (new REAL_8 [DATA_SET_SIZE]);
	std::fill( &(data[0]), &(data[ DATA_SET_SIZE ]), REAL_8( 3.1415) );
        FrameCPP::FrVect::data_type junk( reinterpret_cast< FrameCPP::FrVect::data_type::element_type * >( data.release() ));

        SharedPtr<FrameCPP::FrVect>
        aux_vect (new FrameCPP::FrVect(
        /*        "dataValid",
                  1, aux_dims, "" */
                  //"dataValid", 1, aux_dims, data1, ""
                "dataValid",
                FrameCPP::FrVect::RAW,                        /* Compress */
                FrameCPP::FrVect::FR_VECT_8R,                 /* Type */
                1, aux_dims,
                DATA_SET_SIZE,                      /* NData */
                DATA_SET_SIZE * sizeof( REAL_8 ),   /* NBytes */

                junk, ""
                ));
        adc -> RefAux().append (aux_vect);

        DATA_SET_SIZE = 65536 * frame_length_seconds;
        AutoArray< REAL_4 > data4 (new REAL_4 [DATA_SET_SIZE]);
	std::fill( &(data4[0]), &(data4[ DATA_SET_SIZE ]), REAL_8( 3.1415) );
        FrameCPP::FrVect::data_type junk4( reinterpret_cast< FrameCPP::FrVect::data_type::element_type * >( data4.release() ));


        FrameCPP::Dimension dims[1]
          = { FrameCPP::Dimension (65536 * frame_length_seconds,
				   1. / 65536,
				   "time") };
        SharedPtr<FrameCPP::FrVect>
        vect (new FrameCPP::FrVect(
                "junk4",
                FrameCPP::FrVect::RAW,                        /* Compress */
                FrameCPP::FrVect::FR_VECT_4R,                 /* Type */
                1, dims,
                DATA_SET_SIZE,                      /* NData */
                DATA_SET_SIZE * sizeof( REAL_4 ),   /* NBytes */
                junk4, ""
                ));
        adc -> RefData().append (vect);
      }

    frame -> GetRawData () -> RefFirstAdc ().append (adc);
  }
  return frame;
}

int frames_per_file = 1;
int blocks_per_frame = 16;

int
main()
{
  FrameCPP::Initialize( );

  long frame_cntr;
  SharedPtr<FrameCPP::FrameH> frame;

  if (frames_per_file != 1) {
	printf("Not supported frames_per_file=%d\n", frames_per_file);
	abort();
  }

  frame = full_frame (0, 0, blocks_per_frame);

  if (!frame) {
    return -1;
  }

  for (frame_cntr = 0; frame_cntr == 0; frame_cntr++)
    {
      int eof_flag = 0;
      time_t frame_start;
      time_t gps = 0, gps_n = 0;
      GPSTime gps_frame_start( gps, gps_n );
      struct tm tms;


      if (eof_flag)
	break;

      frame_start = gps_frame_start.GetSeconds( GPSTime::UTC );
      gmtime_r (&frame_start, &tms);
      tms.tm_mon++;

      frame -> SetGTime(FrameCPP::Version::GPSTime (gps, gps_n));
      int fd = creat ("foo", 0644);
      if (fd < 0) {
	//system_log(1, "Couldn't open full frame file `%s' for writing; errno %d", _tmpf, errno);
	//fsd.report_lost_frame ();
	//set_fault ();
	exit(1);
      } else {
	close (fd);
	{
          FrameCPP::Common::FrameBuffer<filebuf>* obuf
	    = new FrameCPP::Common::FrameBuffer<std::filebuf>(std::ios::out);
          obuf -> open("foo", std::ios::out | std::ios::binary);
          FrameCPP::Common::OFrameStream  ofs(obuf);
          ofs.SetCheckSumFile(FrameCPP::Common::CheckSum::CRC);
	  time_t t = time(0);
          ofs.WriteFrame(frame ,
			 //FrameCPP::FrVect::GZIP, 1,
			 //FrameCPP::FrVect::RAW, 1,
			 FrameCPP::FrVect::ZERO_SUPPRESS_OTHERWISE_GZIP, 1,
			 //FrameCPP::Compression::MODE_ZERO_SUPPRESS_SHORT,
			 //FrameCPP::FrVect::DEFAULT_GZIP_LEVEL, /* 6 */
			 FrameCPP::Common::CheckSum::CRC);
	  t = time(0) - t;
          ofs.Close();
          obuf->close();

	}
      }
    }
  LDASTools::AL::AtExit::Cleanup( );
  return 0;
}

