#include <ldas_tools_config.h>

#include "framecpp/Common/Description.hh"
#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/FrameSpec.tcc"

#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/FrTable.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"

using namespace FrameCPP::Version_8;
using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::IStream;
using FrameCPP::Common::OStream;

//=======================================================================
//=======================================================================
FrTable::
FrTable( )
  : object_type( CLASS_ID, StructDescription( ) )
{
}

FrTable::
FrTable( const FrTable& Source )
  : object_type( CLASS_ID, StructDescription( ) ),
    FrTableNPS( Source ),
    FrTablePS( Source )
{
  RefColumn( ) = Source.RefColumn( );
}

FrTable::
FrTable( const FrTableNPS& Source )
  : object_type( CLASS_ID, StructDescription( ) ),
    FrTableNPS( Source )
{
}

FrTable::
FrTable( const std::string& name, INT_4U nrows )
  : object_type( CLASS_ID, StructDescription( ) )
{
  setName( name );
}

FrTable::
FrTable( Common::IStream& Stream )
  : object_type( CLASS_ID, StructDescription( ) )
{
  m_data( Stream );
  m_refs( Stream );

  Stream.Next( this );
}

FrTable::
FrTable( Previous::FrTable& Source,
	 Common::IStream* Stream )
  : object_type( CLASS_ID, StructDescription( ) ),
    FrTableNPS( Source )
{
  if ( Stream )
  {
    //-------------------------------------------------------------------
    // Fix references
    //-------------------------------------------------------------------
    Stream->ReplaceRef( Source.RefColumn( ), RefColumn( ),
			m_refs.MAX_REF );

  }
}

FrTable::
~FrTable( )
{
}

FrTable& FrTable::
Merge( const FrTable& RHS )
{
  throw
    Unimplemented( "FrTable& FrTable::Merge( const FrTable& RHS )",
		   DATA_FORMAT_VERSION, __FILE__, __LINE__ );
  return *this;
}

const char* FrTable::
ObjectStructName( ) const
{
  return StructName( );
}

const std::string& FrTable::
GetNameSlow( ) const
{
  return GetName( );
}

bool FrTable::
operator==( const Common::FrameSpec::Object& RHS ) const
{
  return compare( *this, RHS );
}

FrTable& FrTable::
operator+=( const FrTable& RHS )
{
  throw Unimplemented( "FrTable& FrTable::operator+=( const FrTable& RHS )",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
}

const Description* FrTable::
StructDescription( )
{
  static Description ret;

  if ( ret.size( ) == 0 )
  {
    ret( FrSH( FrTable::StructName( ), FrTable::CLASS_ID,
	       "Table  Data Structure" ) );

    data_type::Describe< FrSE >( ret );
    refs_type::Describe< FrSE >( ret );

    ret( FrSE( "next", ptr_struct_type::Desc( StructName( ) ) ) );

    ret( FrSE( "chkSum", CheckSumDataClass( ), CheckSumDataComment( ) ) );
  }

  return &ret;
}

FrTable::demote_ret_type FrTable::
demote( INT_2U Target,
	demote_arg_type Obj,
	Common::IStream* Stream ) const
{
  if ( Target >= DATA_FORMAT_VERSION )
  {
    return Obj;
  }
  try
  {
    //-------------------------------------------------------------------
    // Create a newly demoted instance.
    //-------------------------------------------------------------------
    LDASTools::AL::SharedPtr< Previous::FrTable >
      retval( new Previous::FrTable( *this ) );

    //-------------------------------------------------------------------
    // Modify references
    //-------------------------------------------------------------------
    if ( Stream )
    {
#define SRR__( R ) \
      Stream->ReplaceRef( retval->R( ), R( ), m_refs.MAX_REF )

      SRR__(RefColumn);
#undef SRR__
    }
    //-------------------------------------------------------------------
    // Return demoted object
    //-------------------------------------------------------------------
    return retval;
  }
  catch( ... )
  {
  }

  throw
    Unimplemented( "Object* FrTable::Demote( Object* Obj ) const",
		   DATA_FORMAT_VERSION, __FILE__, __LINE__ );
}

FrTable::promote_ret_type FrTable::
promote( INT_2U Source,
	 promote_arg_type Obj,
	 Common::IStream* Stream ) const
{
  return PromoteObject< Previous::FrTable, FrTable >
    ( DATA_FORMAT_VERSION, Source, Obj, Stream );
}

FrameCPP::cmn_streamsize_type  FrTable::
pBytes( const Common::StreamBase& Stream ) const
{
  cmn_streamsize_type retval
    = m_data.Bytes( Stream )
    + m_refs.Bytes( Stream )
    + Stream.PtrStructBytes( )	// next
    ;
  return retval;
}

FrTable* FrTable::
pCreate( Common::IStream& Stream ) const
{
  return new FrTable( Stream );
}

void FrTable::
pWrite( Common::OStream& Stream ) const
{
  m_data( Stream );
  m_refs( Stream );

  WriteNext( Stream );
}
