#include <ldas_tools_config.h>

#include "framecpp/Version4/FrameSpec.hh"

#include "framecpp/Version4/PTR_STRUCT.hh"
#include "framecpp/Version4/StreamRef.hh"

#include "framecpp/Version4/FrameH.hh"
#include "framecpp/Version4/FrAdcData.hh"
#include "framecpp/Version4/FrDetector.hh"
#include "framecpp/Version4/FrEndOfFile.hh"
#include "framecpp/Version4/FrEndOfFrame.hh"
#include "framecpp/Version4/FrHeader.hh"
#include "framecpp/Version4/FrHistory.hh"
#include "framecpp/Version4/FrMsg.hh"
#include "framecpp/Version4/FrProcData.hh"
#include "framecpp/Version4/FrRawData.hh"
#include "framecpp/Version4/FrSE.hh"
#include "framecpp/Version4/FrSerData.hh"
#include "framecpp/Version4/FrSH.hh"
#include "framecpp/Version4/FrSimData.hh"
#include "framecpp/Version4/FrSimEvent.hh"
#include "framecpp/Version4/FrStatData.hh"
#include "framecpp/Version4/FrSummary.hh"
#include "framecpp/Version4/FrTable.hh"
#include "framecpp/Version4/FrTrigData.hh"
#include "framecpp/Version4/FrVect.hh"

namespace FrameCPP
{
  namespace Version_4
  {
    using Common::FrameSpec;

    bool init_frame_spec( );

    static const bool Initialized = init_frame_spec( );

    bool
    init_frame_spec( )
    {
      
      static bool initialized = false;

      if ( ! initialized )
      {
	//---------------------------------------------------------------
	// Local storage describing implementation of the frame spec
	//---------------------------------------------------------------
	std::auto_ptr< FrameSpec::Info >
	  info( new FrameSpec::Info( DATA_FORMAT_VERSION,
				     LIBRARY_MINOR_VERSION ) );

	info->FrameObject( new PTR_STRUCT );
	info->FrameObject( new StreamRef );

	info->FrameObject( new FrameH );
	info->FrameObject( new FrAdcData );
	info->FrameObject( new FrDetector );
	info->FrameObject( new FrEndOfFile );
	info->FrameObject( new FrEndOfFrame );
	info->FrameObject( new FrHeader );
	info->FrameObject( new FrHistory );
	info->FrameObject( new FrMsg );
	info->FrameObject( new FrProcData );
	info->FrameObject( new FrRawData );
	info->FrameObject( new FrSE );
	info->FrameObject( new FrSerData );
	info->FrameObject( new FrSH );
	info->FrameObject( new FrSimData );
	info->FrameObject( new FrSimEvent );
	info->FrameObject( new FrStatData );
	info->FrameObject( new FrSummary );
	info->FrameObject( new FrTable );
	info->FrameObject( new FrTOC );
	info->FrameObject( new FrTrigData );
	info->FrameObject( new FrVect );

	//---------------------------------------------------------------
	// Register with the stream manipulator
	//---------------------------------------------------------------
	FrameSpec::SpecInfo( FrameSpec::version_type( DATA_FORMAT_VERSION ),
			     info.release( ) );
	initialized = true;
      }
      return true;
    }
  }
}
