#ifndef FrameCPP__COMMON__FR_TOC_HH
#define FrameCPP__COMMON__FR_TOC_HH

#include "framecpp/Common/FrameSpec.hh"
#include "framecpp/Common/STRING.hh"
#include "framecpp/Common/FrStatData.hh"

namespace FrameCPP
{
  namespace Common
  {
    class Description;

    class FrTOC
      : public FrameSpec::Object
    {
    public:
      typedef INT_8U	cmn_position_type;
      typedef INT_4U	channel_id_type;

      enum query_info_type {
	TOC_CHANNEL_NAMES,
	TOC_DETECTOR,
	TOC_FR_STRUCTS
      };

      class FunctionBase
      {
      public:
	virtual ~FunctionBase( );
      };
      
      //-----------------------------------------------------------------
      /// \brief Function class used by ForEach method
      ///
      /// This function class is used to describe a function that
      /// takes as its parameters a single character argument.
      //-----------------------------------------------------------------
      class FunctionC
	: public FunctionBase
      {
      public:	
	//---------------------------------------------------------------
	/// \brief Destructor
	//---------------------------------------------------------------
	virtual ~FunctionC( );

	//---------------------------------------------------------------
	/// \brief Prototype for function.
	//---------------------------------------------------------------
	virtual void operator()( char C ) = 0;
      };

      class FunctionString
	: public FunctionBase
      {
      public:
	virtual ~FunctionString( );

	virtual void operator()( const std::string& StrObj ) = 0;
      };

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      class FunctionSI
	: public FunctionBase
      {
      public:	
	//---------------------------------------------------------------
	/// \brief Destructor
	//---------------------------------------------------------------
	virtual ~FunctionSI( );

	//---------------------------------------------------------------
	/// \brief Prototype for function.
	//---------------------------------------------------------------
	virtual void operator()( const std::string& S, INT_4U I ) = 0;
      };

      typedef LDASTools::AL::SharedPtr< FrameSpec::Object >	object_type;

      static const Common::FrameSpec::Info::frame_object_types s_object_id
      = Common::FrameSpec::Info::FSI_FR_TOC;

      FrTOC( const Description* Desc );

      typedef std::vector< STRING< INT_2U > > cmn_name_container_type;
      typedef std::vector< REAL_8 > cmn_dt_container_type;
      typedef std::vector< INT_4U > cmn_GTimeS_container_type;
      typedef std::vector< INT_4U > cmn_GTimeN_container_type;

      virtual ~FrTOC( );

      
      virtual void ForEach( query_info_type Info, FunctionBase& Action ) const;

      virtual void IndexObject( object_type Obj,
				std::streampos Position ) = 0;

      //-----------------------------------------------------------------
      // 
      //-----------------------------------------------------------------

      virtual void FrStatDataQuery( const std::string& NamePattern,
				    const LDASTools::AL::GPSTime& StartTime,
				    const LDASTools::AL::GPSTime& EndTime,
				    const INT_4U Version,
				    FrStatData::Query& Result ) const = 0;

      //-----------------------------------------------------------------
      // Interface routines
      //-----------------------------------------------------------------
      virtual INT_4U nFrame( ) const = 0;

      virtual const cmn_dt_container_type& dt( ) const = 0;
      virtual const cmn_GTimeS_container_type& GTimeS( ) const = 0;
      virtual const cmn_GTimeN_container_type& GTimeN( ) const = 0;

      //-----------------------------------------------------------------
      /// \brief Retrieve the stream position for the detector
      ///
      /// \param[in] Name
      ///     The name of the detector for which the position is
      ///     being requested.
      ///
      /// \return
      ///     Upon successfully locating the requested detector,
      ///     its position within the stream is returned,
      ///     otherwise a detailed exception is throw.
      //-----------------------------------------------------------------
      virtual cmn_position_type positionDetector( const std::string& Name ) const = 0;

      virtual cmn_position_type positionH( INT_4U FrameIndex ) const = 0;
      virtual const cmn_name_container_type& nameADC( ) const = 0;
      virtual cmn_position_type positionADC( INT_4U FrameIndex,
					     const std::string& Channel ) const = 0;
      virtual cmn_position_type positionADC( INT_4U FrameIndex,
					     channel_id_type Channel ) const = 0;
      virtual cmn_position_type positionEvent( INT_4U FrameIndex,
					       const std::string& Channel ) const = 0;
      virtual const cmn_name_container_type& nameProc( ) const = 0;
      virtual cmn_position_type positionProc( INT_4U FrameIndex,
					      const std::string& Channel ) const = 0;
      virtual cmn_position_type positionProc( INT_4U FrameIndex,
					      channel_id_type Channel ) const = 0;
      virtual const cmn_name_container_type& nameSim( ) const = 0;
      virtual cmn_position_type positionSim( INT_4U FrameIndex,
					     const std::string& Channel ) const = 0;
      virtual const cmn_name_container_type& nameSer( ) const = 0;
      virtual cmn_position_type positionSer( INT_4U FrameIndex,
					     const std::string& Channel ) const = 0;
      virtual cmn_position_type positionSimEvent( INT_4U FrameIndex,
						  const std::string& Channel ) const = 0;

      virtual INT_4U nSH( ) const = 0;
      virtual INT_2U SHid( INT_4U Offset ) const = 0;
      virtual const std::string& SHname( INT_4U Offset ) const = 0;

      //-----------------------------------------------------------------
      /// \brief Cache where the positions of the Adc channels
      ///
      /// \param[in,out] Stream
      ///     The Stream being read
      //-----------------------------------------------------------------
      virtual void cacheAdcDataPositions( istream_type& Stream ) = 0;

      //-----------------------------------------------------------------
      /// \brief Advance to the specified Adc channel
      ///
      /// \param[in,out] Stream
      ///     The Stream being read
      /// \param[in] Channel
      ///     The requested channel
      //-----------------------------------------------------------------
      virtual void seekAdcDataPositions( istream_type& Stream,
					 channel_id_type Channel ) = 0;
      //-----------------------------------------------------------------
      /// \brief Advance to the specified Adc channel
      ///
      /// \param[in,out] Stream
      ///     The Stream being read
      /// \param[in] Channel
      ///     The requested channel
      //-----------------------------------------------------------------
      virtual void seekAdcDataPositions( istream_type& Stream,
					 const std::string& Channel ) = 0;

    protected:
      void setAdcDataPoisitions( );

    private:
      cmn_position_type	adc_data_positions_from_end;
    };
  } // namespace - Common
} // namespace - FrameCPP

#endif /* FrameCPP__COMMON__FR_TOC_HH */
