#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/ReadWriteLock.hh"

#include "ldastoolsal/UnitTestTS.h"

using LDASTools::AL::MutexLock;
using LDASTools::AL::ReadWriteLock;

struct lock_check_info
{
  //---------------------------------------------------------------------
  // Inputs
  //---------------------------------------------------------------------
  ReadWriteLock::lock_mode	mode;

  //---------------------------------------------------------------------
  // Outputs
  //---------------------------------------------------------------------
  std::exception* 		err;
};

LDASTools::Testing::UnitTestTS	Test;

static MutexLock::baton_type		mutex_baton;
static ReadWriteLock::baton_type	rwlock_baton;

#include "tThreadMutex.cc"
#include "tThreadRWLock.cc"

int
main( int ArgC, char** ArgV )
{
  //---------------------------------------------------------------------
  // Initialize the test structure
  //---------------------------------------------------------------------
  Test.Init(ArgC, ArgV);

  //---------------------------------------------------------------------
  // Verify MutexLock
  //---------------------------------------------------------------------
  test_mutex_lock_baton( );
  test_mutex_lock( );
  test_mutex_lock_mix_and_match( );

  //---------------------------------------------------------------------
  // Verify ReadWriteLock
  //---------------------------------------------------------------------
  test_rw_lock_baton( );
  test_rw_lock_baton_locking( );

  //---------------------------------------------------------------------
  // Exit with the appropriate exit status
  //---------------------------------------------------------------------
  Test.Exit();
  return 1;
}
