#include <sys/types.h>

#include <iostream>
#include <sstream>
#include <vector>

#include "ldastoolsal/gpstime.hh"
#include "ldastoolsal/PSInfo.hh"

using LDASTools::AL::PSInfo;

typedef std::vector< PSInfo >	pids_list;

int
main( int ArgC, char** ArgV )
{
  pids_list	pids;

  for ( int x = 1; x < ArgC; x++ )
  {
    std::istringstream	pid_string( ArgV[ x ] );
    pid_t	pid;

    pid_string >> pid;

    pids.push_back( PSInfo( pid ) );
  }
  PSInfo::psinfo_type	pid_info;
  while( 1 )
  {
    for( pids_list::const_iterator
	   cur = pids.begin( ),
	   last = pids.end( );
	 cur != last;
	 ++cur )
    {
      try
      {
	(*cur)( pid_info );
	std::cout << LDASTools::AL::GPSTime::NowGPSTime( )
		  << " " << pid_info.s_pid
		  << " " << pid_info.s_fname
		  << " " << pid_info.s_pcpu
		  << " " << pid_info.s_pmem
		  << std::endl;
      }
      catch( const std::exception& Exception )
      {
	std::cerr << "ERROR: " << Exception.what( ) << std::endl;
      }
      catch( ... )
      {
      }
    }
    sleep( 2 );
  }
  return 0;
}
