#include <ldas_tools_config.h>

#include <iostream>
#include <cstring>   

#include "regexmatch.hh"


//-----------------------------------------------------------------------------
/// \brief  Constructor
///
/// \param nmatches
///
RegexMatch::
RegexMatch( off_type nmatches ) throw(std::bad_alloc)
  : mMatches( 0 ),
    mNMatches( nmatches ),
    mString( 0 ),
    found( 0 )
{
    if ( mNMatches > 0 )
    {
        mMatches = new regmatch_t[ mNMatches ];
    }
}


//-----------------------------------------------------------------------------
/// \brief  Destructor
///
RegexMatch::~RegexMatch() throw()
{
    delete[] mMatches;
    mMatches = 0;
}


//-----------------------------------------------------------------------------
/// \brief  Perform a Regex Match
///
/// \param r Precompiled pattern buffer
/// \param string Text string containing the input text
/// \param eflags flag which cause changes in matching behavior
///+	(see: man regexec).
///
/// \return bool true if match was found, false otherwise
///
bool RegexMatch::match( const Regex& r, const char* string, flag_type eflags )
    throw()
{
   bool retval;

   mString = string;

   retval = ( ( r.compiled( ) )
	      ? ( regexec( &r.getPattern(), mString, mNMatches, mMatches, eflags )
		  == 0 )
	      : false );
   
   found = 0;
   if ( retval )
   {
     for ( off_type c = 0;
	   ( c < mNMatches)
	     && ( mMatches[ c ].rm_so != -1 );
	   ++c, ++found )
     {
       // Looping until we find the end of patterns
     }
   }
   return retval;
}


//-----------------------------------------------------------------------------
/// \brief  Get Substring
///
/// Return a substring as a C++ string object.
///
/// \param m Index of match starting from zero.
///
/// \return std::string - Value of the match if m is within the number of
///+	 matches, the empty string otherwise.
///
std::string RegexMatch::getSubString( off_type m ) throw()
{
    if ( getSubStart( m ) == 0 )
    {
        return "";
    }

    return std::string( getSubStart( m ), getSubLength( m ) );
}

    
