#ifndef LDASTOOLSAL__TIMER_THREAD_HH
#define LDASTOOLSAL__TIMER_THREAD_HH

#include <signal.h>

#include <list>

#include "ldastoolsal/gpstime.hh"
#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/Singleton.hh"
#include "ldastoolsal/types.hh"

namespace LDASTools
{
  namespace AL
  {
    /// \brief  Keep track of threads to be run for a specified time.
    class TimerThread
      : public Singleton< TimerThread >
    {
    public:
      /// \brief  Unique key
      typedef INT_4U key_t;

      TimerThread( );
      ~TimerThread( );

      key_t AddTimer( int Wakeup, int Signal );
      bool RemoveTimer( key_t Key );

    private:
      //-----------------------------------------------------------------
      /// \brief Forward declaration of structure holding private data.
      ///
      /// \note
      ///      This structure is defined in the source code to
      ///      abstract the implementation.
      //-----------------------------------------------------------------
      struct p_type;
      //-----------------------------------------------------------------
      /// \brief A reference to the private data
      //-----------------------------------------------------------------
      std::unique_ptr< p_type >	p_;
    };
  } // namespace - AL
} // namespace - LDASTools

#endif /* LDASTOOLSAL__TIMER_THREAD_HH */
