/* -*- mode: c++; c-basic-offset: 2; -*- */

#include <ldas_tools_config.h>

#include <iostream>

#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/Task.hh"

#include "MutexLockBaton.cc"

namespace LDASTools
{
  namespace AL
  {
    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    struct Task::_p_type
    {
    public:
      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      typedef Task::signal_type signal_type;

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      inline _p_type( signal_type CancelSignal )
	: cancel_signal( CancelSignal ),
	  delete_on_completion( false )
      {
      }

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      inline ~_p_type( )
      {
      }

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      signal_type			cancel_signal;
      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      bool			delete_on_completion;
      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      MutexLock::baton_type	lock;
    }; // struct - _p_type

    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    Task::
    Task( signal_type CancelSignal )
      : _p( new _p_type( CancelSignal ) )
    {
    }

    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    Task::
    ~Task( )
    {
    }

    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    MutexLock::baton_type Task::
    Baton( ) const
    {
      return _p->lock;
    }

    //-------------------------------------------------------------------
    /// 
    //-------------------------------------------------------------------
    Task::signal_type Task::
    CancelSignal( ) const
    {
      return _p->cancel_signal;
    }

    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    bool Task::
    DeleteOnCompletion( ) const
    {
      return _p->delete_on_completion;
    }

    //-------------------------------------------------------------------
    /// This function is called regardless of why the task was
    /// terminated.
    /// It allows for any special cleanup or other action that needs to
    /// happen at the end of a task regardless of why the task
    /// terminated.
    //-------------------------------------------------------------------
    void Task::
    OnCompletion( int TaskThreadState )
    {
    }

    void Task::
    delete_on_completion( bool Value )
    {
      _p->delete_on_completion = Value;
    }
  } // namespace - AL
} // namespace - LDASTools
