#include "ldastoolsal/SystemCallTask.hh"
#include "ldastoolsal/TaskThread.hh"

namespace LDASTools
{
  namespace AL
  {
    //-------------------------------------------------------------------
    /// Because system calls can be very peristant within a thread
    /// context, system calls are set up to background without a reaper
    /// to prevent resource starvation for the rest of the code.
    //-------------------------------------------------------------------
    SystemCallTask::
    SystemCallTask( )
      : Task( TaskThread::CANCEL_SIGNAL_ABANDON )
    {
    }

    //-------------------------------------------------------------------
    /// Setup the running of the system call.
    //-------------------------------------------------------------------
    void SystemCallTask::
    operator( )( )
    {
      // Set the errno in the local thread.
      errno = 0;
      m_returnCode = -1;
      try
      {
	m_returnCode = eval( );
      }
      catch( ... )
      {
	// capture errno
	m_errNo = errno;
	throw;
      }
      // capture errno
      m_errNo = errno;
    }
  }
}
