#ifndef LDASTOOLSAL__AT_EXIT_HH
#define LDASTOOLSAL__AT_EXIT_HH

#include <list>

#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/Singleton.hh"

namespace LDASTools
{
  namespace AL
  {
    class AtExit
    {
    public:
      //-----------------------------------------------------------------
      /// \brief  Type specifier for exit functions.
      //-----------------------------------------------------------------
      typedef void (*ExitFunction)();

      //-----------------------------------------------------------------
      /// \brief  Add a cleanup function to call when program is exiting.
      ///
      /// \param[in] Function
      ///     The function to be called when exiting
      ///
      /// \param[in] Name
      ///     A descriptive name of the action being taken
      ///
      /// \param[in] Ring
      ///     The level at which to call.
      ///     The ring structure is inverted in that rings of higher value
      ///     are called prior to rings of lesser values.
      //-------------------------------------------------------------------
      static void Append( ExitFunction Function,
			  const std::string& Name,
			  int Ring );

      //-----------------------------------------------------------------
      /// \brief Release all resources entrusted
      //-----------------------------------------------------------------
      static void Cleanup( );

      //-----------------------------------------------------------------
      /// \brief Query the exiting state of the system.
      //-----------------------------------------------------------------
      static bool IsExiting( );

    };
  } // namespace - AL
} // namespace - LDASTools

#if DEPRICATED_NAMESPACE_GENERAL
namespace General
{
  using LDASTools::AL::AtExit;
}
#endif /* DEPRICATED_NAMESPACE_GENERAL */

#endif /* LDASTOOLSAL__AT_EXIT_HH */
