#if HAVE_CONFIG_H
#include <ldas_tools_config.h>
#endif /* HAVE_CONFIG_H */

#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/unordered_map.hh"

#include "genericAPI/Symbols.hh"

using LDASTools::AL::MutexLock;
using LDASTools::AL::unordered_map;

namespace GenericAPI
{
  //---------------------------------------------------------------------
  // The API name
  //---------------------------------------------------------------------
  static MutexLock::baton_type
  api_name_baton( )
  {
    static MutexLock::baton_type baton( __FILE__, __LINE__ );

    return baton;
  }

  static std::string&
  api_name( )
  {
    static std::string api( "" );
    return api;
  }

  void
  APINameGet( std::string& Name )
  {
    MutexLock	l( api_name_baton( ),
		   __FILE__, __LINE__ );

    Name = api_name( );
  }

  void
  APINameSet( const std::string& Name )
  {
    MutexLock	l( api_name_baton( ),
		   __FILE__, __LINE__ );

    api_name( ) = Name;
  }

  //---------------------------------------------------------------------
  // The email notify lists
  //---------------------------------------------------------------------
  typedef unordered_map< std::string, std::string >
  email_notify_container_type;

  static MutexLock::baton_type EMailNotifyBaton( __FILE__, __LINE__ );
  static email_notify_container_type EMailNotify;

  void
  EMailNotifyGet( const std::string& Name,
		  std::string& Value )
  {
    MutexLock	l( EMailNotifyBaton,
		   __FILE__, __LINE__ );
    
    email_notify_container_type::const_iterator
      pos = EMailNotify.find( Name );
    if ( pos == EMailNotify.end( ) )
    {
      Value = EMailNotify[ "default" ];
    }
    else
    {
      Value = pos->second;
    }
  }

  void
  EMailNotifySet( const std::string& Name,
		  const std::string& Value )
  {
    MutexLock	l( EMailNotifyBaton,
		   __FILE__, __LINE__ );

    EMailNotify[ Name ] = Value;
  }

  namespace Symbols
  {
#define INIT(x,y)\
    MutexLock::baton_type symbol< x::value_type >::m_baton( __FILE__, __LINE__ ); \
    x::value_type symbol< x::value_type >::m_value = y

#if 1
#else
    INIT(HTTPUrl,"");
#endif

    // INIT(RUN_CODE,"StandAlone");

#undef INIT

    SYMBOL_CLASS_INIT(HTTP_URL,"");
    SYMBOL_CLASS_INIT(LDAS_ARCHIVE_DIR,"");
    SYMBOL_CLASS_INIT(LDAS_LOG_DIR,"");
    SYMBOL_CLASS_INIT(LDAS_MANAGER_HOST,"");
    SYMBOL_CLASS_INIT(LDAS_MANAGER_KEY,"");
    SYMBOL_CLASS_INIT(LDAS_MANAGER_PORT_EMERGENCY,0);
    SYMBOL_CLASS_INIT(LDAS_SYSTEM,"StandAlone");
    SYMBOL_CLASS_INIT(RUN_CODE,"StandAlone");
  }
}
