/* -*- mode: c++; c-basic-offset: 4; -*- */
#include <ldas_tools_config.h>

// System Header Files
#include <sstream>   
   
#include "framecpp/Time.hh"

// Local Header Files
#include "FrRawData.hh"
#include "util.hh"

using FrameCPP::Common::SearchContainer;

using namespace std;
   
namespace FrameAPI
{
    namespace FrRawData
    {
	//---------------------------------------------------------------
	//!param: FrameCPP::FrRawDaa* Primary - This will containe the
	//+		source plusthe infomation from Secondary
	//!param: FrameCPP::FrRawData* Secondary - Additional information to be
	//+		merged with Primary
	//!return: FrameCPP::FrRawData* - The union of Primary and Secondary


	FrameCPP::FrRawData*
	merge( FrameCPP::FrRawData* Primary,
	       const FrameCPP::FrRawData* Secondary )
	{
	    //-----------------------------------------------------------
	    // If BOTH the primary and the secondary are null, just
	    //   return a null pointer
	    //-----------------------------------------------------------
	    if ( ( Primary == (FrameCPP::FrRawData*)NULL ) &&
		 ( Secondary == (FrameCPP::FrRawData*)NULL ) )
	    {
		return (FrameCPP::FrRawData*)NULL;
	    }
	    //-----------------------------------------------------------
	    // If the primary is null and the secondary is non-null,
	    //   return a duplicate of the second
	    //-----------------------------------------------------------
	    if ( Primary == (FrameCPP::FrRawData*)NULL )
	    {
		return new FrameCPP::FrRawData( *Secondary );
	    }
	    //-----------------------------------------------------------
	    // If the primary is non-null and the secondary is null,
	    //   return the primary.
	    //-----------------------------------------------------------
	    if ( Secondary == (FrameCPP::FrRawData*)NULL )
	    {
		return Primary;
	    }
	    //-----------------------------------------------------------
	    // :TODO: Merging of data fields
	    //-----------------------------------------------------------
	    return Primary;
	}
    }
}
