#ifndef FrameCPP_VERSION_8_FrTOCSerData_HH
#define FrameCPP_VERSION_8_FrTOCSerData_HH

#include "framecpp/Version4/FrTOCPosition.hh"

#include "framecpp/Version7/FrTOCSerData.hh"

#include "framecpp/Version8/STRING.hh"

namespace FrameCPP
{
  namespace Common
  {
    class TOCInfo;
  }

  namespace Version_8
  {
    using Version_4::FrTOCPosition;

    //===================================================================
    /// \brief Indexed elements of the FrSerData structure.
    //===================================================================
    class FrTOCSerData
      : public FrTOCPosition
    {
    public:
      typedef FrTOCPosition::n_type		nser_type;
      typedef FrTOCPosition::position_type	position_type;

      typedef FrTOCPosition::info_type	ser_info_type;
      typedef FrTOCPosition::Map_type	MapSer_type;

      //-----------------------------------------------------------------
      /// \brief Default constructor.
      //-----------------------------------------------------------------
      FrTOCSerData( );

      //-----------------------------------------------------------------
      /// \brief The description of structure
      ///
      /// \return
      ///     A Description object which describes this structure as
      ///     specified by the frame specification.
      //-----------------------------------------------------------------
      template< typename SE >
      static void Description( Common::Description& Desc );

      //-----------------------------------------------------------------
      /// \brief Return all channels
      ///
      /// \return
      ///     Constant container to the indexed FrSerData elements.
      //-----------------------------------------------------------------
      const MapSer_type& GetSer( ) const;

      //-----------------------------------------------------------------
      /// \brief Return the indexed data for a named channel.
      ///
      /// \param[in] Name
      ///     The name of the channel.
      ///
      /// \return
      ///     Constant iterator to the indexed FrSerData element.
      //-----------------------------------------------------------------
      MapSer_type::const_iterator GetSer( const std::string& Name ) const;

      //-----------------------------------------------------------------
      /// \brief Return the indexed data for a named channel.
      ///
      /// \param[in] index
      ///     The numeric offset of the channel.
      ///
      /// \return
      ///     Constant iterator to the indexed FrSerData element.
      //-----------------------------------------------------------------
      MapSer_type::const_iterator GetSer( INT_4U index ) const;

      //-----------------------------------------------------------------
      /// \brief Gather TOC info for FrSerData being written.
      ///
      /// \param[in] Info
      ///     Information
      ///
      /// \param[in] FrameOffset
      ///     The frame offset of the frame being written.
      ///     The frame offsets start at 0 (zero).
      ///
      /// \param[in] Position
      ///     The byte offset from the start of the file
      ///     where the structure is written.
      //-----------------------------------------------------------------
      void QuerySer( const Common::TOCInfo& Info,
		     INT_4U FrameOffset,
		     INT_8U Position );

      //-----------------------------------------------------------------
      /// \brief asignment operator
      ///
      /// \param[in] Source
      ///     The source to be copied.
      //-----------------------------------------------------------------
      const FrTOCSerData& operator=( const Previous::FrTOCSerData& Source );

      //-----------------------------------------------------------------
      /// \brief equality operator
      ///
      /// \param[in] RHS
      ///     The FrTOCAdcData object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      bool operator==( const FrTOCSerData& RHS ) const;

    protected:
      //-----------------------------------------------------------------
      /// \brief Stream constructor
      ///
      /// \param[in] Stream
      ///     The input stream from where the object is being read.
      ///
      /// \param[in] FrameCount
      ///     The frame offset.
      //-----------------------------------------------------------------
      FrTOCSerData( Common::IStream& Stream, INT_4U FrameCount );

      //-----------------------------------------------------------------
      /// \brief Write the structure to the stream
      ///
      /// \param[in] Stream
      ///     The output stream where the object is to be written.
      //-----------------------------------------------------------------
      void write( Common::OStream& Stream ) const;
    };

    inline FrTOCSerData::
    FrTOCSerData( )
    {
    }

    inline FrTOCSerData::
    FrTOCSerData( Common::IStream& Stream, INT_4U FrameCount )
      : FrTOCPosition( Stream, FrameCount )
    {
    }

    template< typename SE >
    void FrTOCSerData::
    Description( Common::Description& Desc )
    {
      Desc( SE( "nSer", "INT_4U",
		"Number of unique FrSerData names in file." ) );
      Desc( SE( "nameSer", "STRING[nSer]", "Array of FrSerData names" ) );
      Desc( SE( "positionSer", "INT_8U[nSer][nFrame]",
		"Array of lists of FrSerData offset positions, in bytes,"
		" from beginning of file (size of nFrame*nSer)"
		) );
    }

    inline const FrTOCSerData::MapSer_type& FrTOCSerData::
    GetSer( ) const
    {
      return getInfo( );
    }

    inline FrTOCSerData::MapSer_type::const_iterator FrTOCSerData::
    GetSer( const std::string& Channel ) const
    {
      return getInfo( Channel );
    }

    inline FrTOCSerData::MapSer_type::const_iterator FrTOCSerData::
    GetSer( INT_4U Channel ) const
    {
      return getInfo( Channel );
    }

    inline void FrTOCSerData::
    write( Common::OStream& Stream ) const
    {
      FrTOCPosition::write( Stream );
    }
  } // namespace - Version_8
} // namespace - FrameCPP

#endif /* FrameCPP_VERSION_8_FrTOCSerData_HH */
