#ifndef FRAMECPP__COMMON__FrameStreamPlanWrapper_HH
#define FRAMECPP__COMMON__FrameStreamPlanWrapper_HH

#include "framecpp/Common/FrameStreamWrapper.hh"


#undef DECL
#define DECL INT_2U SPEC, typename AdcData, typename FrameH, typename ProcData, typename SerData, typename SimData, typename RawData, typename Event, typename SimEvent
#undef DECL_PARAMS
#define DECL_PARAMS SPEC, AdcData, FrameH, ProcData, SerData, SimData, RawData, Event, SimEvent

namespace FrameCPP
{
  namespace Common
  {
    /// Frame Reading FrameStreamPlanWrapper
    template < DECL >
    class IFrameStreamPlanWrapper
      : public IFrameStreamWrapper< DECL_PARAMS >
    {
    public:
      typedef IFrameStreamWrapper<DECL_PARAMS>		base_type;
      typedef typename base_type::buffer_type		buffer_type;
      typedef typename base_type::frame_offset_type	frame_offset_type;
      typedef typename base_type::fr_adc_data_type	fr_adc_data_type;
      typedef IFrameStreamPlanWrapper<DECL_PARAMS>	plan_type;

      IFrameStreamPlanWrapper( buffer_type* Stream,
			       plan_type* master = 0 );

      ~IFrameStreamPlanWrapper( );

      //-----------------------------------------------------------------
      /// \brief Extract the requested FrAdcData structure from the stream
      ///
      /// \param[in] Frame
      ///     Zero based index of the frame.
      /// \param[in] Channel
      ///     Zero based index of channel being requested.
      ///
      /// \return
      ///     Upon success, a non-NULL pointer to the FrAdcData is
      ///     returned. Upon failure, either an exception is thrown
      //      or a NULL pointer is returned.
      //-----------------------------------------------------------------
      fr_adc_data_type ReadFrAdcData( frame_offset_type Frame, INT_4U Channel );

      //-----------------------------------------------------------------
      /// \brief Extract the requested FrAdcData structure from the stream
      ///
      /// \param[in] Frame
      ///     Zero based index of the frame.
      /// \param[in] Channel
      ///     Name of the channel being requested.
      ///
      /// \return
      ///     Upon success, a non-NULL pointer to the FrAdcData is
      ///     returned. Upon failure, either an exception is thrown
      //      or a NULL pointer is returned.
      //-----------------------------------------------------------------
      fr_adc_data_type ReadFrAdcData( frame_offset_type Frame, const std::string& Channel );

    private:
      IFrameStreamPlanWrapper	*master_plan;
      bool			reset_positions;

      void reset_adc_data_positions( );

      void reset_adc_data_positions( frame_offset_type Frame, INT_4U Channel );

      void reset_adc_data_positions( frame_offset_type Frame, const std::string& Channel );
    }; // class FrameReadPlanWrapper

    template <DECL>
    inline IFrameStreamPlanWrapper<DECL_PARAMS>::
    IFrameStreamPlanWrapper( buffer_type* Stream, IFrameStreamPlanWrapper *master )
      : IFrameStreamWrapper<DECL_PARAMS>(Stream),
	master_plan(master),
	reset_positions( true )
    {
      if (master_plan) {
	// Will not load the TOC but rather use the master plan TOC 
	// :TODO: need to see if the TOC size is still the same and
	// that the frame sequence is continuous
	// Assign the TOC pointer from the mater plan
	this->seedTOCInfo( *master_plan );
      }
      else
      {
	reset_positions = false;
      }
    }

    template <DECL>
    inline IFrameStreamPlanWrapper<DECL_PARAMS>::
    ~IFrameStreamPlanWrapper()
    {
    }

    template <DECL>
    inline typename IFrameStreamPlanWrapper<DECL_PARAMS>::fr_adc_data_type
    IFrameStreamPlanWrapper<DECL_PARAMS>::
    ReadFrAdcData( frame_offset_type Frame, INT_4U Channel )
    {
      if ( master_plan )
      {
	reset_adc_data_positions( Frame, Channel );
      }
      return 
	IFrameStreamWrapper< DECL_PARAMS >::ReadFrAdcData( Frame, Channel );
    }

    template <DECL>
    inline typename IFrameStreamPlanWrapper<DECL_PARAMS>::fr_adc_data_type
    IFrameStreamPlanWrapper<DECL_PARAMS>::
    ReadFrAdcData( frame_offset_type Frame, const std::string& Channel )
    {
      if ( master_plan )
      {
	reset_adc_data_positions( Frame, Channel );
      }
      return 
	IFrameStreamWrapper< DECL_PARAMS >::ReadFrAdcData( Frame, Channel );
    }

    template <DECL>
    inline void IFrameStreamPlanWrapper<DECL_PARAMS>::
    reset_adc_data_positions( )
    {
      if ( reset_positions )
      {
	IFrameStream::getTOC( )->cacheAdcDataPositions( *this );
	reset_positions = false;
      }
    }

    template <DECL>
    inline void IFrameStreamPlanWrapper<DECL_PARAMS>::
    reset_adc_data_positions( frame_offset_type Frame, INT_4U Channel )
    {
      reset_adc_data_positions( );
      IFrameStream::getTOC( )->seekAdcDataPositions( *this, Channel );
    }

    template <DECL>
    inline void IFrameStreamPlanWrapper<DECL_PARAMS>::
    reset_adc_data_positions( frame_offset_type Frame, const std::string& Channel )
    {
      reset_adc_data_positions( );
      IFrameStream::getTOC( )->seekAdcDataPositions( *this, Channel );
    }
  } // namespace - Common
} // namespace - FrameCPP


#undef DECL
#undef DECL_PARAMS

#endif /* FRAMECPP__COMMON__FrameStreamPlanWrapper_HH */
