#ifndef FrameCPP__COMMON__CheckSumFilter_HH
#define FrameCPP__COMMON__CheckSumFilter_HH

#if ! defined(SWIGIMPORTED)
#include <memory>
#endif /* ! defined(SWIGIMPORTED) */

#include "framecpp/Common/CheckSum.hh"
#include "framecpp/Common/StreamFilter.hh"

namespace FrameCPP
{
  namespace Common
  {
    //-------------------------------------------------------------------
    /// \brief Filtering algorythm for calculating checksums.
    //-------------------------------------------------------------------
    class CheckSumFilter
      : public StreamFilter
    {
    public:
      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] Type
      ///     The type of checksum to be calculated.
      ///
      /// \return
      ///     A new instance of the class.
      //-----------------------------------------------------------------
      CheckSumFilter( CheckSum::kind_type Type );

      //-----------------------------------------------------------------
      /// \brief Filter a sequence of bytes
      ///
      /// \param[in] Buffer
      ///     The sequence of bytes to be filter.
      /// \param[in] Size
      ///     The number of bytes in Buffer.
      //-----------------------------------------------------------------
      void Filter( const void* Buffer, INT_8U Size );

      CheckSum* GetChecksum( ) const;

      CheckSum::kind_type Type( ) const;

      INT_4U Value( );

    protected:
      virtual void filter( const char* Buffer, INT_8U Size );

    private:
      std::auto_ptr< CheckSum >	m_checksum;
    };

    inline void CheckSumFilter::
    Filter( const void* Buffer, INT_8U Size )
    {
      filter( static_cast<const char*>( Buffer ), Size );
    }

    inline CheckSum* CheckSumFilter::
    GetChecksum( ) const
    {
      return m_checksum.get( );
    }

    inline CheckSum::kind_type CheckSumFilter::
    Type( ) const
    {
      if ( m_checksum.get( ) )
      {
	return m_checksum->GetType( );
      }
      return CheckSum::NONE;
    }

    inline INT_4U CheckSumFilter::
    Value( )
    {
      if ( m_checksum.get( ) )
      {
	return m_checksum->value( );
      }
      return 0;
    }
  } // namespace - Common
} // namespace - FrameCPP
#endif /* FrameCPP__COMMON__CheckSumFilter_HH */
