#if HAVE_CONFIG_H
#include "general/config.h"
#endif /* HAVE_CONFIG_H */

#include <unistd.h>

#include "general/fstream.hh"
#include "general/unittest.h"

using General::fstream;
using General::ifstream;
using General::ofstream;

General::UnitTest Test;

namespace {
  void
  read_test( )
  {
    Test.Message( ) << "DEBUG: read_test: " << std::endl;
    static const char* file_name( "reading_test" );

    //-------------------------------------------------------------------
    // Seed the file with data
    //-------------------------------------------------------------------
    std::ofstream out_file( file_name );
    out_file << "Hello World" << std::endl;
    out_file.close( );

    try
    {
      //-----------------------------------------------------------------
      // Open the file
      //-----------------------------------------------------------------
      ifstream	stream( file_name );
      char	buffer[ 256 ];

      stream.read( buffer, sizeof( buffer ) );

      //-----------------------------------------------------------------
      // Cleanup
      //-----------------------------------------------------------------
      stream.close( );	
      unlink( file_name );
    }
    catch( ... )
    {
      unlink( file_name );
      throw; // rethrow the error
    }
  }

  void
  write_test( )
  {
    Test.Message( ) << "DEBUG: write_test: " << std::endl;
    static const char* file_name( "writing_test" );

    try
    {
      //-----------------------------------------------------------------
      // Open the file
      //-----------------------------------------------------------------
      ofstream	stream( file_name );
      char buffer[ 256 ];
      std::fill( buffer, &buffer[ sizeof(buffer) ], 'a' );

      stream.write( buffer, sizeof( buffer ) );

      //-----------------------------------------------------------------
      // Cleanup
      //-----------------------------------------------------------------
      stream.close( );	
      unlink( file_name );
    }
    catch( ... )
    {
      unlink( file_name );
      throw; // rethrow the error
    }
  }
} // namespace - anonymous

int
main( int ArgC, char** ArgV )
{
  //---------------------------------------------------------------------
  // Initialize the test structure
  //---------------------------------------------------------------------
  Test.Init(ArgC, ArgV);

  //---------------------------------------------------------------------
  // :TODO: Run through a series of tests
  //---------------------------------------------------------------------

  write_test( );
  read_test( );

  //---------------------------------------------------------------------
  // Exit with the appropriate exit status
  //---------------------------------------------------------------------
  Test.Exit();
  return 1;
}

