#include "general/config.h"

#include "ldasexception.hh"
   
//-----------------------------------------------------------------------------
/// \brief  Default Constructor.
///
/// Creates an exception with no error information.
///
LdasException::LdasException()
   : mErrors()
{}


//-----------------------------------------------------------------------------
/// \brief  Constructor.
///
/// \param library
/// \param code
/// \param msg
/// \param info
/// \param file
/// \param line
///
LdasException::LdasException(
   int library, int code, const std::string& msg, const std::string& info,
   const char* file, size_t line )
   : mErrors()
{
    mErrors.push_back( ErrorInfo( library, code, msg, info, file, line ) );
}


//-----------------------------------------------------------------------------
/// \brief  Constructor
///
/// Creates an exception holding the passed ErrorInfo object.
///
/// \param e
///
LdasException::LdasException( const ErrorInfo& e )
   : mErrors()
{
    mErrors.push_back( e );
}


//-----------------------------------------------------------------------------
/// \brief  Copy Constructor
///
/// \param e
///
LdasException::LdasException( const LdasException& e )
   : mErrors( e.mErrors )
{}


//-----------------------------------------------------------------------------
/// \brief  Destructor
///
LdasException::~LdasException()
{}


//-----------------------------------------------------------------------------
/// \brief  Assignment Operator
///
/// \param e
///
/// \return LdasException&
///
LdasException& LdasException::operator=( const LdasException& e )
{
    if ( this != &e )
    {
        mErrors = e.mErrors;
    }

    return *this;
}

   
//-----------------------------------------------------------------------------
/// \brief  Get Error Info
///
/// \param i
///
/// \return const ErrorInfo&
///   
///!exc: range_error   
///
const ErrorInfo& LdasException::getError( size_t i ) const
{
    if ( i >= mErrors.size() )
    {
        throw std::range_error( "index out of range" );
    }

    return mErrors[ i ];
}

    
//-----------------------------------------------------------------------------
/// \brief  Array Operator
///
/// \param i
///
/// \return const ErrorInfo&
///
///!exc: range_error
///
const ErrorInfo& LdasException::operator[]( size_t i ) const
{
    return getError( i );
}
   

//-----------------------------------------------------------------------------
/// \brief  Add Error
///
/// Add another error info object to the class.
///
/// \param e
///
void LdasException::addError( const ErrorInfo& e )
{
    mErrors.push_back( e );
    return;
}
   
    
//-----------------------------------------------------------------------------
/// \brief  Add Error
///
/// Add another error info object to the class.
///
/// \param library
/// \param code
/// \param msg
/// \param info
/// \param file
/// \param line
///
void LdasException::addError( int library, int code,
   const std::string& msg, const std::string& info,
   const char* file, size_t line )
{
    addError( ErrorInfo( library, code, msg, info, file, line ) );
    return;
}
   
