#ifndef GENERAL__MEMORY_HH
#define GENERAL__MEMORY_HH

#include "general/config.h"

#include <algorithm>

#if HAVE_MEMORY
#include <memory>
#define NAMESPACE_GENERAL_MEMORY std
#elif HAVE_TR1_MEMORY
#include <tr1/memory>
#define NAMESPACE_GENERAL_MEMORY std::tr1
#endif /* HAVE_TR1_MEMORY */

#ifndef HAVE_UNIQUE_PTR
#define unique_ptr auto_ptr
#endif /* HAVE_UNIQUE_PTR */

namespace General
{
  /// \brief  Deletes a pointer
  template< class T >
  T* DeletePtr( T* Ptr );

  /// \brief  Deletes all pointers from the container
  template< class O, class C >
  inline void Purge( C& Container );

  /// Pointers are deleted and a NULL pointer is returned in its place.
  ///
  /// \param Ptr Pointer to be deleted
  ///
  /// \return Value to use in place of origional pointer
  template< class T >
  inline T* DeletePtr( T* Ptr )
  {
    delete Ptr;
    return (T*)0;
  }

  /// Go through a container of pointes, deleting each and replacing
  ///   the value with the appropriate NULL representation
  ///
  /// \param Container Container of pointers
#if SUPPORTED_TEMPLATES_AS_TEMPLATE_PARAMETERS
  template< class O, template<class> class C >
  inline void Purge( C< O* >& Container )
  {
    std::transform( Container.begin( ), Container.end( ),
		    Container.begin( ), DeletePtr< O > );
  }
#else /* SUPPORTED_TEMPLATES_AS_TEMPLATE_PARAMETERS */
  template< class C >
  inline void Purge( C& Container )
  {
    for ( typename C::iterator
	    cur = Container.begin( ),
	    last = Container.end( );
	  cur != last;
	  ++cur )
    {
      *cur = DeletePtr( *cur );
    }
  }
#endif /* SUPPORTED_TEMPLATES_AS_TEMPLATE_PARAMETERS */
}

#endif /* GENERAL__MEMORY_HH */
