#ifndef FrameCPP_VERSION_4_FrTOCTable_HH
#define FrameCPP_VERSION_4_FrTOCTable_HH

#include "framecpp/Version4/FrTOCPosition.hh"
#include "framecpp/Version4/STRING.hh"

namespace FrameCPP
{
  namespace Common
  {
    class TOCInfo;
  }

  namespace Version_4
  {
    //===================================================================
    //===================================================================
    class FrTOCTable
      : public FrTOCPosition
    {
    public:
      typedef FrTOCPosition::n_type		ntable_type;
      typedef FrTOCPosition::position_type	position_type;

      typedef FrTOCPosition::info_type	table_info_type;
      typedef FrTOCPosition::Map_type	MapTable_type;

      FrTOCTable( );

      static void Description( Common::Description& Desc );

      const MapTable_type& GetTable( ) const;

      MapTable_type::const_iterator GetTable( const std::string& Name ) const;

      MapTable_type::const_iterator GetTable( INT_4U index ) const;

      void QueryTable( const Common::TOCInfo& Info,
		     INT_4U FrameOffset,
		     INT_8U Position );

      bool operator==( const FrTOCTable& RHS ) const;

    protected:
      typedef std::vector< name_type >	key_container_type;
      key_container_type	m_keys;
      MapTable_type		m_info;

      FrTOCTable( Common::IStream& Stream, INT_4U FrameCount );
      void write( Common::OStream& Stream ) const;
    };


    inline FrTOCTable::
    FrTOCTable( )
    {
    }

    inline FrTOCTable::
    FrTOCTable( Common::IStream& Stream, INT_4U FrameCount )
      : FrTOCPosition( Stream, FrameCount )
    {
    }

    inline const FrTOCTable::MapTable_type& FrTOCTable::
    GetTable( ) const
    {
      return getInfo( );
    }

    inline FrTOCTable::MapTable_type::const_iterator FrTOCTable::
    GetTable( const std::string& Channel ) const
    {
      return getInfo( Channel );
    }

    inline FrTOCTable::MapTable_type::const_iterator FrTOCTable::
    GetTable( INT_4U Channel ) const
    {
      return getInfo( Channel );
    }

    inline void FrTOCTable::
    write( Common::OStream& Stream ) const
    {
      FrTOCPosition::write( Stream );
    }
  } // namespace - Version_4
} // namespace - FrameCPP

#endif /* FrameCPP_VERSION_4_FrTOCTable_HH */
