/* -*- mode: c++ -*- */
#ifndef FR_SIM_DATA_I
#define FR_SIM_DATA_I

%module frameCPP

%{
#include "general/types.hh"
#include "framecpp/FrSimData.hh"

using namespace FrameCPP;
%}

%import "framecpp/FrameCPP.hh"
%import "framecpp/FrSimData.hh"

%feature("autodoc",
"""
FrSimData (Simulated Data) implementation of the frame specification.

  Attributes:

    name     Name of simulated data.
    comment  Comment.
""" ) FrSimData;

class FrSimData
{
public:
#define DECLARE(X,Y)				\
  typedef FR_SIM_DATA_##Y##_TYPE X##_type

  DECLARE(sampleRate,SAMPLERATE);
  DECLARE(timeOffset,TIMEOFFSET);
  DECLARE(fShift,FSHIFT);
  DECLARE(phase,PHASE);

#undef DECLARE

  FrSimData( );
  FrSimData( const std::string& Name,
	     const std::string& Comment,
	     const sampleRate_type SampleRate, 
	     const fShift_type FShift,
	     const phase_type Phase,
	     const timeOffset_type TimeOffset );

  const std::string& GetName() const; 
  const std::string& GetComment( ) const;

  %extend {
    void
    AppendData( FrVect& Data )
    {
      self->RefData( ).append( Data );
    }

    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    size_t RefDataSize( );
    //-------------------------------------------------------------------
    //-------------------------------------------------------------------
    General::SharedPtr< FrVect > RefData( size_t Offset );
  }

  LDAS_PROPERTY_READ_ONLY("name",GetName)
  LDAS_PROPERTY_READ_ONLY("comment",GetComment)
};

%{
  General::SharedPtr< FrVect >
  FrSimData_RefData( FrSimData* Data, size_t Offset )
  {
    return Data->RefData( )[ Offset ];
  }

  size_t
  FrSimData_RefDataSize( FrSimData* Data )
  {
    return Data->RefData( ).size( );
  }
%}
#endif /* FR_SIM_DATA_I */
