#ifndef FrameCPP__COMMON__DYNAMIC_MEMORY_BUFFER_HH
#define FrameCPP__COMMON__DYNAMIC_MEMORY_BUFFER_HH

#if !defined(SWIGIMPORTED)
#include <list>
#include <iosfwd>
#endif /* !defined(SWIGIMPORTED) */

#include "general/types.hh"
#include "general/autoarray.hh"
#include "general/System.hh"

#include "framecpp/Common/MemoryBuffer.hh"

namespace FrameCPP
{
  namespace Common
  {
    //===================================================================
    /// \brief Buffer appropriate for caching frame data
    ///
    /// If the buffer is for input, then the buffer needs to be
    /// initialized with the contents.
    /// The initialization needs to be done as via by reading
    /// chuncks of data and having the class stitch them together
    /// until a complete frame file object is available for
    /// processing.
    ///
    /// \code
    /// //---------------------------------------------------------------
    /// // The following example uses input from a file to show how
    /// // chuncks of data would be requested and then supplied
    /// // to the class for inclussion in the in memory frame file
    /// // stream.
    /// //===============================================================
    /// // Make sure that everything is reset to the initial conditions
    /// //---------------------------------------------------------------
    /// mb.Reset( );
    ///
    /// General::AutoArray< char >	read_buffer;
    /// DynamicMemoryBuffer::size_type	read_buffer_size = 0;
    /// DynamicMemoryBuffer::size_type	read_size = 0;
    /// std::ifstream			s;
    ///
    /// s.open( filename.c_str( ) );
    /// //---------------------------------------------------------------
    /// // Keep looping till we are informed that a complete frame file
    /// // image is ready for processing
    /// //---------------------------------------------------------------
    /// while ( ! mb.Ready( ) )
    /// {
    ///   //-------------------------------------------------------------
    ///   // Request the number of bytes upon which to wait
    ///   //-------------------------------------------------------------
    ///   read_size = mb.NextBlockSize( );
    ///   //-------------------------------------------------------------
    ///   // Make sure the buffer which hold the temporary results is
    ///   // large enough for the results.
    ///   //-------------------------------------------------------------
    ///   if ( read_buffer_size < read_size )
    ///   {
    ///     read_buffer.reset( new char[ read_size ] );
    ///     read_buffer_size = read_size;
    ///   }
    ///   //-------------------------------------------------------------
    ///   // Read the requested number of bytes, blocking if need be
    ///   //-------------------------------------------------------------
    ///   s.read( read_buffer.get( ), read_size );
    ///   //-------------------------------------------------------------
    ///   // Send them off for processing
    ///   //-------------------------------------------------------------
    ///   mb.NextBlock( read_buffer.get( ), read_size );
    /// }
    /// s.close( );
    /// 
    /// \endcode
    ///
    //===================================================================
    template< typename BT = std::stringbuf >
    class DynamicMemoryBufferT
      : public MemoryBufferT< BT >,
	public FrameBufferInterface::Scanner
    {
    public:
      //-----------------------------------------------------------------
      /// \brief Default constructor
      //-----------------------------------------------------------------
      DynamicMemoryBufferT( bool ParentAutoDelete = true );

      //-----------------------------------------------------------------
      /// \brief Destructor
      //-----------------------------------------------------------------
      virtual ~DynamicMemoryBufferT( );

      //-----------------------------------------------------------------
      /// \brief Add a buffer to the frame file memory image
      ///
      /// \param[in] Buffer
      ///     The buffer to scan
      /// \param[in] Size
      ///     The number of bytes in Buffer
      //-----------------------------------------------------------------
      virtual void NextBlock( const char* Buffer, size_type Size );

      //-----------------------------------------------------------------
      /// \brief Initialize buffer to accumulate a frame file
      //-----------------------------------------------------------------
      virtual void Reset( );

    private:
      typedef FrameBufferInterface::Scanner	scanner_type;

      std::ostringstream			accumulated_buffer;
    };

    //-------------------------------------------------------------------
    // Backwards compatability
    //-------------------------------------------------------------------
    typedef DynamicMemoryBufferT<> DynamicMemoryBuffer;

  } // namespace - Common
} // namespace - FrameCPP

#endif /* FrameCPP__COMMON__DYNAMIC_MEMORY_BUFFER_HH */
