#include "filters/config.h"

#include "LDASConstants.hh"
#include "HannWindow.hh"

extern "C" {
#include <math.h>
}

namespace Filters {

    std::string HannWindow::name() const
    {
	return std::string("Hann Window");
    }

    double HannWindow::param() const
    {
	return 0.0;
    }

    double HannWindow::element(const size_t i) const
    {
	const size_t n = size();

	if (n == 1)
	{
	    return 1.0;
	}
	else
	{
	    double x = 2*LDAS_PI*i/(n-1);
	    return 0.5*(1.0 - cos(x));
	}
    }

    HannWindow* HannWindow::Clone() const
    {
	return new HannWindow(*this);
    }

} // namespace Filters
