# -*- mode: RPM-SPEC; indent-tabs-mode: nil -*-
%define _docdir %{_datadir}/doc/ldas-tools-%{version}

Summary: Suite of LDAS tools
Name: ldas-tools
Version: 1.19.38
Release: 1
License: ?
URL: http://www.ligo.caltech.edu
Group: Application/Scientific
BuildRoot: %{buildroot}
Source0: http://ldas-sw.ligo.caltech.edu/packages/ldas-tools-%{version}.tar.gz
Buildrequires: autoconf automake libtool zlib-devel openssl-devel flex bison swig python-devel

%description
This is a collection of tools developed as part of the LDAS project.

%package general
Group: Application/Scientific
Summary: LDAS tools libgeneral toolkit runtime files
%description general
This provides the runtime libraries for the general library.
Requires: ldas-tools

%package general-devel
Group: Development/Scientific
Summary: LDAS tools libgeneral toolkit development files
%description general-devel
This provides the develpement files the general library.
Requires: ldas-tools-general

%package framecpp
Group: Application/Scientific
Summary: LDAS tools libframecpp toolkit runtime files
%description framecpp
This provides the runtime libraries for the framecpp library.
Requires: ldas-tools-general

%package framecpp-python
Group: Application/Scientific
Summary: Python extension for frameCPP
%description framecpp-python
This provides the libraries needed to utilize the frameCPP library
from within Python
Requires: ldas-tools-framecpp

%package framecpp-devel
Group: Development/Scientific
Summary: LDAS tools libframecpp toolkit development files
%description framecpp-devel
This provides the develpement files the framecpp library.
Requires: ldas-tools-general-devel, ldas-tools-framecpp

%package framecpp-doc
Group: Development/Scientific
Summary: LDAS tools libframecpp documentation
%description framecpp-doc
This provides the documentation for the framecpp library.

%package framecppc
Obsoletes: ldas-tools-framec
Group: Application/Scientific
Summary: LDAS tools c wrapping of libframecpp
%description framecppc
This provides the runtime libraries for the framecpp library.
Requires: ldas-tools-framecpp

%package framecppc-devel
Obsoletes: ldas-tools-framec-devel
Group: Development/Scientific
Summary: LDAS tools libframec toolkit development files
%description framecppc-devel
This provides the develpement files the framecpp library.
Requires: ldas-tools-framecpp-devel

%package filters
Group: Application/Scientific
Summary: LDAS tools libfilters toolkit runtime files
%description filters
This provides the runtime libraries for the filters library.
Requires: ldas-tools-general

%package filters-devel
Group: Development/Scientific
Summary: LDAS tools libfilters toolkit development files
%description filters-devel
This provides the develpement files the filters library.
Requires: ldas-tools-general-devel, ldas-tools-filters

%package genericAPI
Group: Application/Scientific
Summary: LDAS tools libgenericAPI toolkit runtime files
%description genericAPI
This provides the runtime libraries for the genericAPI library.
Requires: ldas-tools-general

%package genericAPI-devel
Group: Development/Scientific
Summary: LDAS tools libgenericAPI toolkit development files
%description genericAPI-devel
This provides the develpement files the genericAPI library.
Requires: ldas-tools-general-devel, ldas-tools-genericAPI

%package frameAPI
Group: Application/Scientific
Summary: LDAS tools libframeAPI toolkit runtime files
%description frameAPI
This provides the runtime libraries for the frameAPI library.
Requires: ldas-tools-filters, ldas-tools-genericAPI

%package frameAPI-devel
Group: Development/Scientific
Summary: LDAS tools libframeAPI toolkit development files
%description frameAPI-devel
This provides the develpement files the frameAPI library.
Requires: ldas-tools-general-devel, ldas-tools-filters-devel, ldas-tools-frameAPI

%package diskcacheAPI
Group: Application/Scientific
Summary: LDAS tools libdiskcacheAPI toolkit runtime files
%description diskcacheAPI
This provides the runtime libraries for the diskcacheAPI library.
Requires: ldas-tools-genericAPI

%package diskcacheAPI-python
Group: Application/Scientific
Summary: Python extension for the disk cache
%description diskcacheAPI-python
This provides the libraries needed to utilize the disk cache library
from within Python
Requires: ldas-tools-diskcacheAPI

%package diskcacheAPI-devel
Group: Development/Scientific
Summary: LDAS tools libdiskcacheAPI toolkit development files
%description diskcacheAPI-devel
This provides the develpement files the diskcacheAPI library.
Requires: ldas-tools-genericAPI-devel, ldas-tools-diskcacheAPI

%package utilities
Group: Application/Scientific
Summary: LDAS tools utility programs
%description utilities
This provides utilities that are useful to end users
Requires: ldas-tools-diskcaheAPI, ldas-tools-frameAPI

%prep

%setup -q

%build

%configure --disable-auto-ldcg-inclusion --without-ospace --without-stlport --with-optimization=high --enable-inlining --without-odbc --disable-metadata-api --disable-tcl --enable-python --docdir=%{_docdir}
make %{?_smp_mflags}
make check

%install
rm -rf %{buildroot}
#--------------------------------------------------------------
# install lscsoft specific files
#--------------------------------------------------------------
make install DESTDIR=%{buildroot}
make lscsoft-install DESTDIR=%{buildroot}
#--------------------------------------------------------------
# Removed unwanted friles from top level Makefile
#--------------------------------------------------------------
rm -rf %{buildroot}%{_bindir}/hotgrep
rm -rf %{buildroot}%{_bindir}/html2text
rm -rf %{buildroot}%{_bindir}/runLDAS
rm -rf %{buildroot}%{_bindir}/scancluster
rm -rf %{buildroot}%{_docdir}/index.html
rm -rf %{buildroot}%{_docdir}/ldasapis/tcl_docs
rm -rf %{buildroot}%{_docdir}/Run_LDAS.html
rm -rf %{buildroot}%{_docdir}/under_const.html
rm -rf %{buildroot}%{_libdir}/*.la
#--------------------------------------------------------------
# Removed unwanted files general
#--------------------------------------------------------------
rm -rf %{buildroot}%{_bindir}/pce2
rm -rf %{buildroot}%{_docdir}/INSTALL_SUITE.html
rm -rf %{buildroot}%{_libdir}/perceps
#--------------------------------------------------------------
# Removed unwanted files frameCPP
#--------------------------------------------------------------
rm -rf %{buildroot}%{python_sitearch}/framecpp/*.la
#--------------------------------------------------------------
# Removed unwanted friles from genericAPI
#--------------------------------------------------------------
rm -rf %{buildroot}%{_bindir}/LDASapi.rsc
rm -rf %{buildroot}%{_bindir}/LDASgwrap
#--------------------------------------------------------------
# Removed unwanted friles from frameAPI
#--------------------------------------------------------------
rm -rf %{buildroot}%{_libdir}/frameAPI/*.la
#--------------------------------------------------------------
# Removed unwanted friles from diskcacheAPI
#--------------------------------------------------------------
rm -rf %{buildroot}%{_bindir}/cacheCheck
rm -rf %{buildroot}%{_bindir}/cacheDump
rm -rf %{buildroot}%{_bindir}/cacheDump.py
rm -rf %{buildroot}%{_bindir}/cacheDump.pyc
rm -rf %{buildroot}%{_bindir}/cacheDump.pyo
rm -rf %{buildroot}%{_bindir}/diskcacheAPI
rm -rf %{buildroot}%{_bindir}/lsync.tcl
rm -rf %{buildroot}%{_libdir}/diskcacheAPI/*.tcl
rm -rf %{buildroot}%{_libdir}/diskcacheAPI/*.la
rm -rf %{buildroot}%{_libdir}/diskcacheAPI/*.ini
rm -rf %{buildroot}%{_libdir}/diskcacheAPI/*.rsc
rm -rf %{buildroot}%{_sbindir}/ldas/ldas-monitor-sys-test
rm -rf %{buildroot}%{python_sitearch}/diskcacheAPI/*.la
#--------------------------------------------------------------
# Removed unwanted files from userAPI
#--------------------------------------------------------------
rm -rf %{buildroot}%{_docdir}/userAPI
rm -rf %{buildroot}%{_bindir}/createRDS.py
rm -rf %{buildroot}%{_bindir}/guild
rm -rf %{buildroot}%{_bindir}/ldas-kill
rm -rf %{buildroot}%{_bindir}/ldas-processes
rm -rf %{buildroot}%{_bindir}/ldas-ps
rm -rf %{buildroot}%{_bindir}/ldas-shutdown
rm -rf %{buildroot}%{_bindir}/ldasinfo
rm -rf %{buildroot}%{_bindir}/mountDump
rm -rf %{buildroot}%{_bindir}/ssh-agent-mgr
rm -rf %{buildroot}%{_sbindir}/SystemTestReport
rm -rf %{buildroot}%{_sbindir}/ldas-stow-build
#--------------------------------------------------------------
# Removed unwanted documentation
#--------------------------------------------------------------
rm -rf %{buildroot}%{_docdir}/tcl_docs
rm -rf %{buildroot}%{_docdir}/gifs

%post
ldconfig
%postun
ldconfig

%clean
rm -rf %{buildroot}

%files
%{_sysconfdir}/ldas-tools-user-env.*

%files general
%defattr(-,root,root,-)
##%{_bindir}
%{_libdir}/libexception*.so*
%{_libdir}/libgeneral*.so*
%{_libdir}/libpreload*.so*

%files general-devel
%defattr(-,root,root)
%{_includedir}/general
%{_includedir}/ldas/ldasconfig.hh
%{_libdir}/libexception.a
%{_libdir}/libgeneral.a
%{_libdir}/libpreload.a
%{_libdir}/pkgconfig/ldasgeneral.pc
%{_docdir}/general

%files framecpp
%defattr(-,root,root,-)
%exclude %{_libdir}/libframecppc.so*
%exclude %{_bindir}/framecpp_*.py
%{_bindir}/framecpp_*
%{_libdir}/libframecpp*.so*

%files framecpp-python
%defattr(-,root,root,-)
%{_bindir}/framecpp_*.py
%{python_sitelib}/framecpp/frameCPP.py*
%{python_sitelib}/framecpp/frgetvect_compat.py*
%{python_sitearch}/framecpp/_frameCPP*.so*
%{python_sitearch}/framecpp/_frameCPP*.a

%files framecpp-devel
%defattr(-,root,root)
%exclude %{_libdir}/libframecppc.*a
%{_includedir}/framecpp
%{_libdir}/libframecpp*.*a
%{_libdir}/pkgconfig/framecpp_common.pc
%{_libdir}/pkgconfig/framecpp3.pc
%{_libdir}/pkgconfig/framecpp4.pc
%{_libdir}/pkgconfig/framecpp6.pc
%{_libdir}/pkgconfig/framecpp7.pc
%{_libdir}/pkgconfig/framecpp8.pc
%{_libdir}/pkgconfig/framecpp.pc

%files framecpp-doc
%defattr(-,root,root)
%doc %{_docdir}/framecpp

%files framecppc
%defattr(-,root,root,-)
%{_libdir}/libframecppc.so*

%files framecppc-devel
%defattr(-,root,root)
%{_includedir}/framecppc
%{_libdir}/libframecppc.*a
%{_libdir}/pkgconfig/framecppc.pc

%files filters
%defattr(-,root,root,-)
%{_libdir}/libfilters*.so*

%files filters-devel
%defattr(-,root,root)
%{_includedir}/filters
%{_docdir}/filters
%{_libdir}/libfilters*.*a
%{_libdir}/pkgconfig/filters.pc

%files genericAPI
%defattr(-,root,root,-)
%{_libdir}/libStat*.so*
%{_libdir}/libgenericCore*.so*
%{_libexecdir}/ldas/lstat

%files genericAPI-devel
%defattr(-,root,root)
%{_includedir}/genericAPI
%{_libdir}/libStat.*a
%{_libdir}/libgenericCore.*a
%{_docdir}/genericAPI

%files frameAPI
%defattr(-,root,root,-)
%{_libdir}/frameAPI/libframe*.so*
%{python_sitelib}/frameAPI/LDASframe.py*
%{python_sitearch}/frameAPI/_LDASframe*.so*
%{python_sitearch}/frameAPI/_LDASframe*.*a


%files frameAPI-devel
%defattr(-,root,root)
%{_includedir}/frameAPI
%{_libdir}/frameAPI/*.*a
%{_libdir}/pkgconfig/frameAPI.pc
%{_docdir}/frameAPI

%files diskcacheAPI
%defattr(-,root,root,-)
%{_bindir}/diskcache
%{_bindir}/ldas-cache-dump-verify
%{_libdir}/diskcacheAPI/libdiskcache*.so*
%{_docdir}/diskcache_poller
%{_docdir}/diskcache_server

%files diskcacheAPI-python
%defattr(-,root,root,-)
%{python_sitelib}/diskcacheAPI/*.py*
%{python_sitearch}/diskcacheAPI/*.so*
%{python_sitearch}/diskcacheAPI/*.*a

%files diskcacheAPI-devel
%defattr(-,root,root)
%{_includedir}/diskcacheAPI
%{_libdir}/diskcacheAPI/*.*a
%{_libdir}/pkgconfig/diskcache.pc
%{_docdir}/diskcacheAPI

%files utilities
%{_bindir}/ldas_create_rds

%changelog
* Fri Oct 11 2011 Edward Maros <emaros@ligo.caltech.edu> - ldas-tools-1
- Initial build.
