#! /usr/bin/env python
#########################################################################
# This implements the createRDS standalone command in python
#########################################################################
import string
import sys
import Tkinter
from optparse import OptionParser

import diskCache
import LDASframe

tcl_interp = Tkinter.Tk().tk.eval
server = diskCache.ServerInterface( )

class createRDS:
    def __init__(self):
        self.queries = []
        self.OFFSET_DESC = 0
        self.OFFSET_IFO = 1
        self.OFFSET_TIME_RANGE = 3
        self.OFFSET_CHANNELS = 4

    def query( self, Options ):
        #----------------------------------------------------------------
        # This method uses the actual TCL interpreter so there is
        #   no confusion of proper translation of string.
        #---------------------------------------------------------------- 
        l = int(tcl_interp("set query %s; llength $query" % Options.query_tcl))

        result = []
        for counter in range( l ):
            sq = tcl_interp( "lindex $query %d" % counter )
            sql = int(tcl_interp("set squery {%s}; llength $squery" % sq ))
            sqa = []
            for csq in range ( sql ):
                sqa.append( tcl_interp( "lindex $squery %d" % csq ))
            self.queries.append( sqa )

        #----------------------------------------------------------------
        # Construct the diskcache server request
        #----------------------------------------------------------------
        diskcache_args = []
        for q in self.queries:
            ifo = q[ self.OFFSET_IFO ]
            desc = q[ self.OFFSET_DESC ]
            t = q[ self.OFFSET_TIME_RANGE ].split( '-' );
            range_start = int( t[0] )
            range_end = int( t[1] )
            results = []
            try:
                results = server.FilenamesRDS( q[ self.OFFSET_IFO ],
                                               q[ self.OFFSET_DESC ],
                                               range_start,
                                               range_end,
                                               '.gwf' );
            except Exception,e:
                print( "WARNING: exception: %s" % ( e ) )
            else:
                #--------------------------------------------------------
                # Have a collection of filenames
                #--------------------------------------------------------
                print results
                #--------------------------------------------------------
                # Parse out the list of channels
                #--------------------------------------------------------
                chan = q[ self.OFFSET_CHANNELS ]
                cb = string.find( chan, '(' )
                cb = cb + 1
                ce = string.rfind( chan, ')' )
                c = chan[cb:ce]
                channels = string.split( c, ',' )
                for channel in channels:
                    print ( "Channel: %s" % channel )
                print( "DEBUG: directory_output_frames: %s" % Options.directory_output_frames )
                print( "DEBUG: directory_output_md5sum: %s" % Options.directory_output_md5sum )
                LDASframe.createRDSSet( range_start,
                                        range_end,
                                        results,
                                        channels,
                                        Options.directory_output_frames,
                                        Options.directory_output_md5sum )
                print( "DEBUG: Done" )
                              

def main():
    parser = OptionParser( )
    parser.add_option("--directory-output-frames",
                      action="store",
                      dest="directory_output_frames",
                      help="Directory holding the generated frame files")
    parser.add_option("--directory-output-md5sum",
                      action="store",
                      dest="directory_output_md5sum",
                      help="Directory holding md5sum values for the generated frame files")
    parser.add_option("--diskcache-host",
                      action="store",
                      dest="host",
                      help="Host number of the diskcache server")
    parser.add_option("--diskcache-port",
                      action="store",
                      dest="port",
                      default='43833',
                      help="Port number of the diskcache server")
    parser.add_option("--frame-query-tcl",
                      action="store",
                      dest="query_tcl",
                      help="Query for the diskcache server that has a TCL look and feel")

    (options, args) = parser.parse_args( )

    server.Server( options.host, int(options.port) )
    crds = createRDS( )
    crds.query( options )

if __name__ == '__main__':
    main()
