#ifndef GENERIC_API__LOGGING_HH
#define GENERIC_API__LOGGING_HH

#include <string>

#include "general/gpstime.hh"
#include "genericAPI/LogHTML.hh"

namespace GenericAPI
{
  typedef LogHTML LogEntryGroup_type;
  //---------------------------------------------------------------------
  /// \brief Queue a message to be written to a log file
  ///
  /// \param[in] Message
  ///     The text of the message to be written to the log file.
  /// \param[in] Group
  ///     The group classification of the message to be logged.
  /// \param[in] Level
  ///     The level at which the message will be logged.
  /// \param[in] Caller
  ///     The function or method name of the routine logging the message.
  /// \param[in] JobInfo
  ///     Descriptive text of job logging the message.
  /// \param[in] Time
  ///     The time the message was logged.
  /// \param[in] Filename
  ///     The filename of the stream to send the message.
  //---------------------------------------------------------------------
  void
  queueLogEntry( const std::string& Message,
		 const std::string& Group,
		 const int Level,
		 const std::string& Caller,
		 const std::string& JobInfo,
		 const unsigned int Time = 0,
		 const std::string& Filename = std::string( "" ) );

  //---------------------------------------------------------------------
  /// \brief Queue a message to be written to a log file
  ///
  /// \param[in] Message
  ///     The text of the message to be written to the log file.
  /// \param[in] Group
  ///     The group classification of the message to be logged.
  /// \param[in] Level
  ///     The level at which the message will be logged.
  /// \param[in] Caller
  ///     The function or method name of the routine logging the message.
  /// \param[in] JobInfo
  ///     Descriptive text of job logging the message.
  /// \param[in] Time
  ///     The time the message was logged.
  /// \param[in] Filename
  ///     The filename of the stream to send the message.
  //---------------------------------------------------------------------
  void
  queueLogEntry( const std::string& Message,
		 const int Group,
		 const int Level,
		 const std::string& Caller,
		 const std::string& JobInfo,
		 const unsigned int Time = 0,
		 const std::string& Filename = std::string( "" ) );

  //---------------------------------------------------------------------
  /// \brief Establish level of debugging output
  //---------------------------------------------------------------------
  void
  setLogDebugLevel( const int Level,
		    const std::string& Filenaem = std::string( "" ) );
}

#endif /* GENERIC_API__LOGGING_HH */

