#ifndef RDS_STREAM_FILE_HH
#define RDS_STREAM_FILE_HH

#include "filereader.hh"
#include "RDSStream.hh"

class RDSStreamFile
  : public RDSStream
{
public:
  typedef std::list< std::string >	result_type;
  typedef INT_4U			rds_level_type;

  RDSStreamFile( const std::string& OutputDirectory,
		 const std::string& OutputType,
		 const rds_level_type RDSLevel,
		 const std::string& MD5SumOutputDirectory );

  virtual void Abandon( );

  virtual void Close( bool Final );

  virtual bool Next( const General::GPSTime& FrameStart,
		     const REAL_8 Dt,
		     INT_4U& FramesPerStream );

  const result_type& Results( ) const;

  rds_level_type RDSLevel( ) const;

  virtual void Write( frame_h_type Frame,
		      compression_scheme_type CompressionScheme,
		      compression_level_type CompressionLevel,
		      chkSum_type CheckSum );

protected:
  typedef General::SharedPtr< FileWriter > file_writer_type;
  typedef REAL_8 delta_t_type;

  INT_4U	m_frame_file_start;
  delta_t_type	m_frame_file_deltaT;
  std::string	m_md5sum_output_directory;

  virtual void appendOutputFrameFilename( const std::string& Filename );

  virtual void closeFrameFile( const std::string& Filename,
			       bool Final );

  virtual void openFrameFile( const std::string& Filename );

  void ensureNoSuchFile( const std::string& Filename ) const;

  file_writer_type fileWriter( );

  std::string
  generateOutputName( INT_4U FileStart,
		      REAL_8 FileDeltaT ) const;

  std::string
  generateTmpOutputName( INT_4U FileStart ) const;

private:
  std::string		m_output_directory;
  result_type		m_output_frame_names;
  const std::string	m_output_type;
  const rds_level_type	m_rds_level;

  file_writer_type	m_writer;
};


inline RDSStreamFile::rds_level_type RDSStreamFile::
RDSLevel( ) const
{
  return m_rds_level;
}

inline const RDSStreamFile::result_type& RDSStreamFile::
Results( ) const
{
  return m_output_frame_names;
}

inline RDSStreamFile::file_writer_type RDSStreamFile::
fileWriter( )
{
  return m_writer;
}

#endif /* RDS_STREAM_FILE_HH */
